package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventListenerService;
import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Locale;

@Slf4j
@Component
public class EventListener extends EventBaseService {

    @Autowired
    private EventListenerService eventListenerService;

    /**
     * 消费ATMC转发的消息
     *
     * @param data
     * @param channel
     * @param tag
     * @throws IOException
     */
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_QUEUE_NAME, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_ROUTING_NAME
    ), concurrency = "#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('" + EventMqConstants.EVENT_MQ_QUEUE_NAME + "')}")
    @RabbitRetry(beforeHandler = "ptmMqBeforeHandler", successHander = "ptmMqSuccessHandler", failureHandler = "ptmMqFailureHandler")
    public void receiveOrder(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_QUEUE_NAME, channel, tag, retryCount);
    }


    /**
     * 重写：处理mq消息
     */
    @Override
    public void processMessage(String data, EventListenerDTO eventListenerDTO) {
        log.info("[athena.event.message.abt-data]: processMessage data = {}, eventListener = {}", data, JsonUtils.objectToString(eventListenerDTO));
        //防止这块逻辑出现异常，统一加个事务回滚
        eventListenerService.processMsg(data, eventListenerDTO);
        log.info("消费ptm消息成功（atmc转发）");
//        LogDto logDto = new LogDto("消费ptm消息成功（atmc转发）", eventListenerDTO.getUser().getTenantId());
//        log.info(logDto.toString());
    }
}
