package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.exception.RejectRetryException;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import lombok.extern.slf4j.Slf4j;

import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Component
public class ExportBasicDataRedisListener {
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    private MetaDataService metaDataService;

    @Autowired
    private EspService espService;

    @Autowired
    private BaseDataEntryApplicationServiceImpl baseDataEntryService;

    @Autowired
    private TokenVerifyService tokenVerifyService;

    @Resource
    private ExportBatchRecordMapper recordMapper;


    @Autowired
    private ExportProcessor exportProcessor;

    @Autowired
    private ExcelHelperV2 excelHelperV2;

    public void consumer(ExportFileMsg exportFileMsg) {
        log.info("basicdata consumer masterId:{}", exportFileMsg.getMasterId());

        ExportStatistics exportStatistics = exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            //将消息丢弃
            log.error("未找到对应数据masterId:{},exportStatistics:{}", exportFileMsg.getMasterId(), exportStatistics);
            // 抛异常，在catch中统一处理
            return;
        }

        try {
            // 1、查询API元数据
            String actionId = exportFileMsg.getActionId();
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();

            //上下文处理
            DWSecurityContext dwSecurityContext = setContext(userToken);

            // 获取元数据信息
            GetActionLocaleResponseDTO metadataDTO = metaDataService.getActionMetaDataBySecurityToken(actionId, dwSecurityContext.getUserToken(), locale, userToken);
            DownloadBaseDataParamDTO downloadBaseDataParamDTO = exportFileMsg.getDownloadBaseDataParamDTO();
            baseDataEntryService.getActionParas(downloadBaseDataParamDTO);

            exportFileMsg.setApplication(downloadBaseDataParamDTO.getApplication());
            exportFileMsg.setType(exportStatistics.getType());
            // 2、判断是否支持分页,调用应用导出API
//            List<Map<String, Object>> tableList = new ArrayList<>();
            String productName = metaDataService.getProductName(dwSecurityContext.getUserToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0));
            //response主key
            String mainKey = metadataDTO.getResponse().getData().getData_name();
            String mainKeyDesc = metadataDTO.getResponse().getData().getDescription();

            //获取responseKey类型
            Map<String, CellTypeContainer> headersTypeMap = metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), userToken, locale);
            //根据actionId获取excel列名
            List<String> keyList = new ArrayList<>();
            Map<String, String> headers = metaDataService.getResponseHeaders(metadataDTO, keyList);
            // 过滤导出字段
            baseDataEntryService.getExportFileds(downloadBaseDataParamDTO.getActionInfo().getSelectField(), keyList, headersTypeMap);
            String sheetName = ExcelHelperV2.getSheetName(mainKey, mainKeyDesc, true);

            List<CellTypeContainer> businessKeyContainer = excelHelperV2.getBusinessKeyContainer(new ArrayList<>(headersTypeMap.values()));
            List<CellTypeContainer> arrayKeyContainer = excelHelperV2.getArrayKeyContainer(new ArrayList<>(headersTypeMap.values()));

            Set<String> arrayField = CollectionUtils.isEmpty(arrayKeyContainer)
                    ? new HashSet<>()
                    : arrayKeyContainer.stream()
                    .map(CellTypeContainer::getKeyName)
                    .collect(Collectors.toSet());
            List<ExportBatchRecordPO> batchRecordPOList = recordMapper.listByMasterId(exportStatistics.getMasterId(), null);
            if(!CollectionUtils.isEmpty(batchRecordPOList)){
                List<ExportBatchRecord> exportBatchRecordList = Lists.newArrayListWithExpectedSize(batchRecordPOList.size());
                for (ExportBatchRecordPO exportBatchRecordPO : batchRecordPOList) {
                    ExportBatchRecord cp = JaBeanCopy.cp(exportBatchRecordPO, ExportBatchRecord.class);
                    exportBatchRecordList.add(cp);
                }
                exportStatistics.setExportBatchRecords(exportBatchRecordList);
            }

            if (Boolean.TRUE.equals(metaDataService.useHasNext(metadataDTO))) {
                Integer pageNum = ImportAndExportStatisticsConstants.EXPORT_FILE_DEFAULT_PAGE_NO;
                 exportProcessor.processExport(exportStatistics, workbook -> getBaseDataByPage(downloadBaseDataParamDTO.getActionInfo().getCategory(), exportStatistics, sheetName, workbook, keyList, headersTypeMap, headers, businessKeyContainer, arrayField,
                        downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, mainKey, dwSecurityContext.getUserToken(), pageNum));
            } else {
              exportProcessor.processExport(exportStatistics, workbook -> getBaseData(downloadBaseDataParamDTO.getActionInfo().getCategory(), exportStatistics, sheetName, workbook, keyList, headersTypeMap, headers, businessKeyContainer, arrayField, downloadBaseDataParamDTO.getActionInfo().getActionParas(),
                        exportFileMsg, productName, mainKey, dwSecurityContext.getUserToken()));
            }
            if(!CollectionUtils.isEmpty(exportStatistics.getExportBatchRecords())){
                List<ExportBatchRecord> exportBatchRecords = exportStatistics.getExportBatchRecords();
                for (ExportBatchRecord exportBatchRecord : exportBatchRecords) {
                    ExportBatchRecordPO cp = JaBeanCopy.cp(exportBatchRecord, ExportBatchRecordPO.class);
                    cp.setUpdateTime(new Date());
                    recordMapper.updateById(cp);
                }
            }

            exportStatistics.setUpdateTime(new Date());
            JaLog.info("has been export records size: {}", exportStatistics.getTotalSize());
            exportStatisticsDomainService.updateById(exportStatistics);
        } catch (Exception e) {
            log.error("ExportMQListener consume error:{}", e.getMessage(),e);
//            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
//            exportStatistics.setUpdateTime(new Date());
//            exportStatistics.setTotalSize(0);
//            exportStatisticsDomainService.updateById(exportStatistics);
            throw new RejectRetryException();
        }

        // 4、所有数据处理完毕，发送MQTT消息
//        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics(exportStatistics);
//        eventPublisher.publish(exportSuccessEvent);
    }

    private DWSecurityContext setContext(String userToken) {
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(userToken);
        } catch (Exception e) {
            log.error("解析token失败:{}", userToken);
            // 抛异常，在catch中统一处理
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0106.getErrCode(), MessageUtil.getMessage("delivery.resolveTokenError"), e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();

        // 查询用户信息，后续调外部接口时需要传routerKey
        AuthoredUser authoredUser = tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        return dwSecurityContext;
    }

    /**
     * 设置分页参数查询应用接口
     *
     * @param requestParam
     * @param exportFileMsg
     * @param productName
     * @param mainKey
     * @param userToken
     * @return
     */
    private void getBaseDataByPage(String category, ExportStatistics exportStatistics, String sheetName, SXSSFWorkbook sb, List<String> keyList, Map<String, CellTypeContainer> headersTypeMap,
                                   Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField,
                                   Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String mainKey, String userToken, Integer pageNum) {
        requestParam.put("use_has_next", true);
        requestParam.put("page_size", JaProperty.getInteger(RedisQueueContant.BASE_PAGE_SIZE, 500));
        requestParam.put("page_no", pageNum);

        Boolean hasNext = getBaseData(category, exportStatistics, sheetName, sb, keyList, headersTypeMap, headersMap, businessKeyContainer, arrayField,
                requestParam, exportFileMsg, productName, mainKey, userToken);
        if (Boolean.TRUE.equals(hasNext)) {
            pageNum++;
            getBaseDataByPage(category, exportStatistics, sheetName, sb, keyList, headersTypeMap, headersMap, businessKeyContainer, arrayField,
                    requestParam, exportFileMsg, productName, mainKey, userToken, pageNum);
        }
    }

    /**
     * 查询应用接口
     */
    private Boolean getBaseData(String category, ExportStatistics exportStatistics, String sheetName, SXSSFWorkbook sb, List<String> keyList,
                                Map<String, CellTypeContainer> headersTypeMap, Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField,
                                Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String mainKey, String userToken) {
        Boolean hasNext;
        EspResponse espResponse = espService.getBaseData(requestParam, exportFileMsg, productName, userToken);
        if (Objects.isNull(espResponse) || !espResponse.isOK()) {
            log.error("getBaseData fail! exportFileMsg:{}", exportFileMsg);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0067.getErrCode(), MessageUtil.getMessage("delivery.exportDataError"));
        }
        EspBody espBody = (EspBody) espResponse.getData();
        if (Objects.isNull(espBody) || Objects.isNull(espBody.getStd_data()) || CollectionUtils.isEmpty(espBody.getStd_data().getParameter())
                || Objects.isNull(espBody.getStd_data().getParameter().get(mainKey))) {
            log.error("getBaseData espResponse is null! exportFileMsg:{}", exportFileMsg);
            return false;
        }
        if (espBody.getStd_data().getParameter().containsKey(ImportAndExportStatisticsConstants.HAS_NEXT)) {
            hasNext = (Boolean) espBody.getStd_data().getParameter().get(ImportAndExportStatisticsConstants.HAS_NEXT);
        } else {
            hasNext = false;
        }

        List<Map<String, Object>> tableList = (List<Map<String, Object>>) espBody.getStd_data().getParameter().get(mainKey);
        //累计数量
        int totalSize = exportStatistics.getTotalSize();
        //当前查询tablelist数量
        int currentSize = CollectionUtils.isEmpty(tableList) ? 0 : tableList.size();
        // 双档导出数据最多2000条（按单头数量计算）
        int limit = JaProperty.getInteger(RedisQueueContant.BASE_REDIS_QUEUE_LIMIT_SIZE, 2000);

        if ((totalSize + currentSize) > limit && ImportAndExportStatisticsConstants.CATEGORY_DOUBLE_DOCUMENT.equals(category)) {
            int retainSize = limit - totalSize;
            if (retainSize > 0 && retainSize < currentSize) {
                tableList = tableList.subList(0, retainSize);
                hasNext = false;
            } else if (retainSize <= 0) {
                // 如果超过限制，清空 tableList
                tableList = Collections.emptyList();
                hasNext = false;
            }
        }

        if (!CollectionUtils.isEmpty(tableList)) {
            excelHelperV2.createDataExcel(sheetName, exportFileMsg.getLocale(), 2, keyList, headersTypeMap,
                    headersMap, tableList, sb, businessKeyContainer, 0, null, null, arrayField
            );
            exportStatistics.setTotalSize(exportStatistics.getTotalSize() + tableList.size());
        }
        return hasNext;
    }

}

