package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.utils.LockPoolDataEntryHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.HistoryDataConstant;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.locks.ReentrantLock;

@Slf4j
@Component
public class ExportHistoryDataMQListener extends ExportHistoryDataParentService {

    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private AtmcService atmcService;

    @RabbitListener(
            queues = "#{exportHistoryDataFileQueueName}", ackMode = "AUTO"
    )
    /**
     * 历史项目任务导出异步消费
     */
    @RabbitHandler
    public void consumer(String msg) {
        ExportFileMsg exportFileMsg = JsonUtils.jsonToObject(msg, ExportFileMsg.class);
        ExportStatistics exportStatistics = exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            //将消息丢弃
            log.error("未找到对应数据masterId:{},exportStatistics:{}", exportFileMsg.getMasterId(), exportStatistics);
            // 抛异常，在catch中统一处理
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0060.getErrCode(), MessageUtil.getMessage("delivery.dataNotFound"));
        }

        Date now = new Date();
        int lockId = LockPoolDataEntryHelper.getIdByUUID(exportFileMsg.getMasterId(), lockPool.getPoolSize());
        ReentrantLock lock = lockPool.getLockById(lockId);
        lock.lock();
        try {
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();

            // userToken
            DWSecurityToken dwSecurityToken;
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(userToken);
            } catch (Exception e) {
                log.error("解析token失败:{}", userToken);
                // 抛异常，在catch中统一处理
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0106.getErrCode(), MessageUtil.getMessage("delivery.resolveTokenError"), e);
            }
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();

            // 查询用户信息，后续调外部接口时需要传routerKey
            AuthoredUser authoredUser = tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

            //获取实际的历史项目任务数据
            Map<String, Object> param = exportFileMsg.getHistoryDownloadBaseDataParam();//入参
            Map<String, Object> paramMap = MapUtils.getMap(param, "searchInfo", null);
            List<Map<String, Object>> list = new ArrayList<>();
//            for (int i = 0; i < 11; i++) {
            getList(list, param, paramMap, locale);
//            }

            Map<String, Object> historydDataInfo = MapUtils.getMap(param, "historydDataInfo", null);
            List<String> keyList = new ArrayList<>();
            if (null != historydDataInfo && historydDataInfo.containsKey("selectField")) {
                keyList = (List<String>) MapUtils.getObject(historydDataInfo, "selectField");
            }
            //实际组装文件及上传到文件存储平台
            long start = System.currentTimeMillis();
            String fileUrl = exportStatisticsDomainService.handleDownloadBaseData(exportStatistics, keyList, HistoryDataConstant.getHeadersMap(locale), HistoryDataConstant.getHeadersTypeMap(locale), list, "sheet");
            log.info("老版本写入execl和上传文件总耗时：{}", System.currentTimeMillis() - start);
            if (!StringUtils.isEmpty(fileUrl)) {
                exportStatistics.setFileUrl(fileUrl);
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("fileUrl is null!");
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
            exportStatistics.setUpdateTime(new Date());
            JaLog.info("export total size :{}", list.size());
            exportStatistics.setTotalSize(list.size());
            exportStatisticsDomainService.updateById(exportStatistics);
        } catch (Exception e) {
            log.error("ExportMQListener consume error:{}", e);
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportStatistics.setUpdateTime(new Date());
            exportStatistics.setTotalSize(0);
            exportStatisticsDomainService.updateById(exportStatistics);
        } finally {
            lock.unlock();
        }

        // 4、所有数据处理完毕，发送MQTT消息
        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics(exportStatistics);
        eventPublisher.publish(exportSuccessEvent);
    }

    private List<Map<String, Object>> getList(List<Map<String, Object>> list, Map<String, Object> param, Map<String, Object> paramMap, String locale) {

        int count = MapUtils.getIntValue(param, "count", 0);
        //分批次查询数据
        if (null != paramMap && count > 0) {
            int pageSize = 500; // 每次查询500条数据
            int totalRecords = 0;
            // 计算需要查询的批次数量
            int numberOfBatches = (count + pageSize - 1) / pageSize; // 向上取整
            for (int i = 0; i < numberOfBatches; i++) {
                // 设置分页参数
                paramMap.put("page", i + 1);
                paramMap.put("rows", pageSize);
                // 调用服务查询数据
//                    List<String> products = getProductName(paramMap);
                List<Map<String, Object>> data = atmcService.findTaskBacklogH(paramMap, locale);
                if (CollectionUtils.isEmpty(data)) {
                    break;
                }
                //保持和Atheana平台展示内容一样的逻辑
                rebuildData(data, locale);
                // 累加查询到的产品数量
                totalRecords += data.size();
                // 将查询结果添加到总列表中
                list.addAll(data);
                // 如果查询结果小于pageSize，说明已经查询完毕
                if (data.size() < pageSize || totalRecords >= count) {
                    break;
                }
            }
        }
        return list;
    }

}

