package com.digiwin.athena.abt.presentation.mq;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;

import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;


@Slf4j
@Component
public class ExportHistoryDataParentService {

    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    MessageUtils messageUtils;

    /**
     * 保持和Atheana平台展示内容一样的逻辑
     * @param data
     */
    public void rebuildData(List<Map<String, Object>> data,String locale) {
        for (Map<String, Object> map : data){
            Integer performerType = MapUtils.getInteger(map,"performerType",null);
            String state = MapUtils.getString(map,"state","");
            String backlogTaskName = MapUtils.getString(map,"backlogTaskName","");
            String historyMessage = MapUtils.getString(map,"historyMessage","");
            String type = MapUtils.getString(map,"type","");

            String oldPerformerName = MapUtils.getString(map,"oldPerformerName","");
            String directionPerformerName = MapUtils.getString(map,"directionPerformerName","");
            Integer sourceState = MapUtils.getInteger(map,"sourceState",0);//sourceState该字段从atmc接口获取，有默认值0，所以不会为空
            Integer directionState = MapUtils.getInteger(map,"directionState",0);//directionState该字段从atmc接口获取，有默认值0，所以不会为空
            String typeDesc = "";
            String stateDesc = "";
            String nameDesc = "";
            String source = "";
            String operate = "";
            //处理type的实际写入值
            //和source/operate写入值
            if ("1".equals(type)){
                //type
                typeDesc = messageUtils.getMessageByLangName("export.history.type.task", locale);
                //设置任务source实际写入值
                source = buildTaskSource(sourceState,source,oldPerformerName,locale);
                //设置任务operate实际写入值
                operate = buildTaskDirectionState(directionState,operate,directionPerformerName,locale);
            }
            if ("0".equals(type)){
                typeDesc = messageUtils.getMessageByLangName("export.history.type.project", locale);
                //设置项目source实际写入值
                source = buildProjectSource(sourceState,source,oldPerformerName,locale);
                operate = messageUtils.getMessageByLangName("export.history.operate.system", locale);//项目的去向默认是提交
            }
            map.put("source",source);
            map.put("operate",operate);
            map.put("type",typeDesc);
            /*String.format(messageUtils.getMessageByLangName("export.history.type", locale), tmActivityName,endTime,projectName)*/
            //处理state的实际写入值
            if ("0".equals(state)){
                //计算逾时的时间：天时分
                String endTime = MapUtils.getString(map,"endTime","");
                String closedTime = MapUtils.getString(map,"closedTime","");
                Map<String,Long> timeMap = new HashMap<>();
                if (StringUtils.isNotEmpty(endTime) && StringUtils.isNotEmpty(closedTime)){
                    calculateTime(timeMap,endTime,closedTime);
                }
                long days = MapUtils.getLongValue(timeMap,"days", 0L); // 总天数
                long hours = MapUtils.getLongValue(timeMap,"hours", 0L); // 小时
                long minutes = MapUtils.getLongValue(timeMap,"minutes", 0L); // 分钟
                if (days>0){
                    stateDesc = String.format(messageUtils.getMessageByLangName("export.history.state.overtime.day", locale), days);
                } else if (hours>0) {
                    stateDesc = String.format(messageUtils.getMessageByLangName("export.history.state.overtime.hour", locale), hours);
                } else if (minutes>0) {
                    stateDesc = String.format(messageUtils.getMessageByLangName("export.history.state.overtime.minute", locale), minutes);
                }
            }else{
                //准时
                stateDesc = messageUtils.getMessageByLangName("export.history.state.punctual", locale);

            }
            map.put("state",stateDesc);
            //处理name的实际写入值
            String name = MapUtils.getString(map,"name","");
            if (null != performerType) {

                if (performerType.equals(1)) {
                    nameDesc = String.format(messageUtils.getMessageByLangName("export.history.working.agent", locale), name);
                } else if (performerType.equals(998)) {
                    nameDesc = String.format(messageUtils.getMessageByLangName("export.history.dj.agent", locale), name);
                } else {
                    nameDesc = name;
                }
            }else {
                nameDesc = name;
            }
            map.put("name", nameDesc);
            StringBuilder sb = new StringBuilder();
            //处理backlogTaskName的实际写入值
//            if (StringUtils.isNotEmpty(backlogTaskName)){
//                Boolean merge = MapUtils.getBoolean(map,"merge",false);
//                String dataFrom = MapUtils.getString(map,"dataFrom","");
//                if (!(BooleanUtils.isTrue(merge) && "PTM".equals(dataFrom))){
//                    String start = getDateStr(MapUtils.getString(map,"backlogTaskStartTime",""));
//                    String end = getDateStr(MapUtils.getString(map,"backlogTaskEndTime",""));
//                    sb.append(start).append("-").append(end).append(backlogTaskName).append("\n");
//                }
//            }
            if (StringUtils.isNotEmpty(historyMessage)){
                String[] historyMessageArr = historyMessage.split("<br>");
                for (int i = 0; i < historyMessageArr.length; i++) {
                    if (i>9){
                        break;
                    }
                    sb.append(historyMessageArr[i]).append("\n");
                }
            }else{
                String summary = MapUtils.getString(map,"summary","");
                if (StringUtils.isNotEmpty(summary)){
                    String[] summaryArr = summary.split("<br>");
                    for (int i = 0; i < summaryArr.length; i++) {
                        if (i>9){
                            break;
                        }
                        sb.append(summaryArr[i]).append("\n");
                    }
                }
            }
            //去除最后一个\n
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n'){
                sb.deleteCharAt(sb.length() - 1);
            }
            map.put("backlogTaskName", sb.toString());
            // 处理所属项目时距
            String projectStartAndEndTime = "";
            Boolean merge = MapUtils.getBoolean(map, "merge", false);
            String dataFrom = MapUtils.getString(map, "dataFrom", "");
            if (!(BooleanUtils.isTrue(merge) && "PTM".equals(dataFrom))) {
                String projectStartTime = getDateStr(MapUtils.getString(map, "projectStartTime", ""));
                String projectEndTime = getDateStr(MapUtils.getString(map, "projectEndTime", ""));
                projectStartAndEndTime = StringUtils.isNotBlank(projectStartTime) && StringUtils.isNotBlank(projectEndTime) ? projectStartTime + "-" + projectEndTime : projectStartAndEndTime;
            }
            map.put("projectStartAndEndTime", projectStartAndEndTime);
            //处理时间格式 和前端保持一致 yyyy-MM-dd HH:mm:ss 转成 yyyy/MM/dd HH:mm:ss
            rebuildDateTime(map);
        }
    }

    /**
     * 项目来源
     * @param sourceState
     * @param source
     * @param oldPerformerName
     * @param locale
     */
    public String buildProjectSource(Integer sourceState, String source, String oldPerformerName, String locale) {
        if (StringUtils.isNotEmpty(oldPerformerName)){//有来源人
            switch (sourceState) {
                case 0://系统新增
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.system", locale), oldPerformerName);
                    break;
                case 1://转派
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.transfer", locale), oldPerformerName);
                    break;
                case 3://交接
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.handover", locale), oldPerformerName);
                    break;
                default:
                    break;
            }
        }else {//无来源人
            switch (sourceState) {
                case 0://系统新增
                    source = messageUtils.getMessageByLangName("export.history.source.system", locale);
                    break;
                case 1://转派
                    source = messageUtils.getMessageByLangName("export.history.source.transfer", locale);
                    break;
                case 3://交接
                    source = messageUtils.getMessageByLangName("export.history.source.handover", locale);
                    break;
                default:
                    break;
            }
        }
        return source;
    }

    /**
     * 设置去向实际写入值
     * @param directionState
     * @param operate
     * @param directionPerformerName
     * @param locale
     */
    public String buildTaskDirectionState(Integer directionState, String operate, String directionPerformerName, String locale) {
        if (StringUtils.isNotEmpty(directionPerformerName)){//有去向人
            switch (directionState) {
                case 0://系统新增
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.system", locale), directionPerformerName);
                    break;
                case 1://转派
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.transfer", locale), directionPerformerName);
                    break;
                case 2://退回重签
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.return", locale), directionPerformerName);
                    break;
                case 3://退回重办
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.return", locale), directionPerformerName);
                    break;
                case 4://加签
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.countersignature", locale), directionPerformerName);
                    break;
                case 9://撤回
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.withdraw", locale), directionPerformerName);
                    break;
                case 10://交接
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.to.handover", locale), directionPerformerName);
                    break;
                case 99://终止
                    operate = String.format(messageUtils.getMessageByLangName("export.history.operate.from.stop", locale), directionPerformerName);
                    break;
                default:
                    break;
            }
        }else {//无去向人
            switch (directionState) {
                case 0://系统提交
                    operate = messageUtils.getMessageByLangName("export.history.operate.system", locale);
                    break;
                case 1://转派
                    operate = messageUtils.getMessageByLangName("export.history.operate.transfer", locale);
                    break;
                case 2://退回重签
                    operate = messageUtils.getMessageByLangName("export.history.operate.return", locale);
                    break;
                case 3://退回重办
                    operate = messageUtils.getMessageByLangName("export.history.operate.return", locale);
                    break;
                case 4://加签
                    operate = messageUtils.getMessageByLangName("export.history.operate.countersignature", locale);
                    break;
                case 9://撤回
                    operate = messageUtils.getMessageByLangName("export.history.operate.withdraw", locale);
                    break;
                case 10://交接
                    operate = messageUtils.getMessageByLangName("export.history.operate.handover", locale);
                    break;
                case 99://终止
                    operate =messageUtils.getMessageByLangName("export.history.operate.stop", locale);
                    break;

                default:
                    break;
            }
        }
        return operate;
    }

    /**
     * 设置来源实际写入值
     * @param sourceState
     * @param source
     * @param oldPerformerName
     */
    public String buildTaskSource(Integer sourceState,String source, String oldPerformerName,String locale) {
        if (StringUtils.isNotEmpty(oldPerformerName)){//有来源人
            switch (sourceState) {
                case 0://系统新增
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.system", locale), oldPerformerName);
                    break;
                case 1://转派
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.transfer", locale), oldPerformerName);
                    break;
                case 2://退回重签
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.return", locale), oldPerformerName);
                    break;
                case 3://退回重办
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.return", locale), oldPerformerName);
                    break;
                case 4://加签
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.countersignature", locale), oldPerformerName);
                    break;
                case 9://撤回
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.withdraw", locale), oldPerformerName);
                    break;
                case 10://交接
                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.handover", locale), oldPerformerName);
                    break;
//                case 99://终止
//                    source = String.format(messageUtils.getMessageByLangName("export.history.source.from.stop", locale), oldPerformerName);
//                    break;
                default:
                    break;
            }
        }else {//无来源人
            switch (sourceState) {
                case 0://系统新增
                    source = messageUtils.getMessageByLangName("export.history.source.system", locale);
                    break;
                case 1://转派
                    source = messageUtils.getMessageByLangName("export.history.source.transfer", locale);
                    break;
                case 2://退回重签
                    source = messageUtils.getMessageByLangName("export.history.source.return", locale);
                    break;
                case 3://退回重办
                    source = messageUtils.getMessageByLangName("export.history.source.return", locale);
                    break;
                case 4://加签
                    source = messageUtils.getMessageByLangName("export.history.source.countersignature", locale);
                    break;
                case 9://撤回
                    source = messageUtils.getMessageByLangName("export.history.source.withdraw", locale);
                    break;
                case 10://交接
                    source = messageUtils.getMessageByLangName("export.history.source.handover", locale);
                    break;
//                case 99://终止
//                    source = String.format(messageUtils.getMessageByLangName("export.history.source.stop", locale), oldPerformerName);
//                    break;
                default:
                    break;
            }
        }
        return source;
    }

    public void rebuildDateTime(Map<String, Object> map) {
        String endTime = MapUtils.getString(map,"endTime","");
        String startTime = MapUtils.getString(map,"startTime","");
        String closedTime = MapUtils.getString(map,"closedTime","");
        String createTime = MapUtils.getString(map,"createTime","");
        if (StringUtils.isNotEmpty(endTime)){
            String endTimeStr = DateUtil.format(DateUtil.parse(endTime,"yyyy-MM-dd HH:mm:ss"),"yyyy/MM/dd HH:mm:ss");
            // 更新map中的值
            map.put("endTime", endTimeStr);
        }
        if (StringUtils.isNotEmpty(startTime)){
            String startTimeStr = DateUtil.format(DateUtil.parse(startTime,"yyyy-MM-dd HH:mm:ss"),"yyyy/MM/dd HH:mm:ss");
            // 更新map中的值
            map.put("startTime", startTimeStr);
        }
        if (StringUtils.isNotEmpty(closedTime)){
            String closedTimeStr = DateUtil.format(DateUtil.parse(closedTime,"yyyy-MM-dd HH:mm:ss"),"yyyy/MM/dd HH:mm:ss");
            // 更新map中的值
            map.put("closedTime", closedTimeStr);
        }
        if (StringUtils.isNotEmpty(createTime)){
            String createTimeStr = DateUtil.format(DateUtil.parse(createTime,"yyyy-MM-dd HH:mm:ss"),"yyyy/MM/dd HH:mm:ss");
            // 更新map中的值
            map.put("createTime", createTimeStr);
        }
    }

    /**
     * 和前端保持一致的逻辑 计算逾时时间天时分
     * @param timeMap
     * @param endTimeString
     * @param closedTimeString
     */
    public static void calculateTime(Map<String,Long> timeMap, String endTimeString, String closedTimeString) {
        // 解析时间字符串为LocalDateTime对象
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime closedTime = LocalDateTime.parse(closedTimeString, formatter);
        LocalDateTime endTime = LocalDateTime.parse(endTimeString, formatter);
        // 计算两个时间之间的相差时间
        Duration duration = Duration.between(endTime, closedTime);

        // 计算天数、小时数和分钟数
        long days = duration.toDays(); // 总天数
        long hours = duration.toHours() % 24; // 除去天数后的小时数
        long minutes = duration.toMinutes() % 60; // 除去小时数后的分钟数
        timeMap.put("days",days);
        timeMap.put("hours",hours);
        timeMap.put("minutes",minutes);
    }

    public String getDateStr(String dateString) {
        if (StringUtils.isEmpty(dateString)){
            return "";
        }
        // 解析原始日期字符串为Date对象
        Date date = DateUtil.parse(dateString,"yyyy-MM-dd HH:mm:ss");
        // 将Date对象格式化为新格式的字符串
        String formattedDateString = DateUtil.format(date,"yyyy/MM/dd");
        return formattedDateString;
    }
}

