package com.digiwin.athena.abt.presentation.mq;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;

import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.history.TaskBacklogHistoryService;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.exception.RejectRetryException;
import com.digiwin.athena.abt.core.meta.constants.HistoryDataConstant;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskBacklogHistoryDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.core.context.ASKContext;
import com.digiwin.athena.framework.core.context.ASKContextEntity;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.fasterxml.jackson.core.type.TypeReference;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Component
public class ExportHistoryDataRedisListener extends ExportHistoryDataParentService {
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    private TokenVerifyService tokenVerifyService;

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private ExcelHelperV2 excelHelperV2;

    @Autowired
    private ExportProcessor exportProcessor;

    @Autowired
    private TaskBacklogHistoryService historyService;

    public void consumer(ExportFileMsg exportFileMsg) {
        log.info("history consumer masterId:{}", exportFileMsg.getMasterId());
//        ExportFileMsg exportFileMsg = JsonUtils.jsonToObject(msg, ExportFileMsg.class);
        ExportStatistics exportStatistics = exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            //将消息丢弃
            log.error("未找到对应数据masterId:{},exportStatistics:{}", exportFileMsg.getMasterId(), exportStatistics);
            return;
        }

        try {
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();
            //入参
            Map<String, Object> param = exportFileMsg.getHistoryDownloadBaseDataParam();
            Map<String, Object> paramMap = MapUtils.getMap(param, "searchInfo", null);
            List<String> keyList = Optional.ofNullable(MapUtils.getMap(param, "historydDataInfo", null))
                    .map(map -> (List<String>) map.get("selectField"))
                    .orElseGet(ArrayList::new);
            int count = MapUtils.getIntValue(param, "count", 0);
            // 获取每页大小配置
            // 每次查询500条数据
            int pageSize = JaProperty.getInteger(RedisQueueContant.HISTORY_PAGE_SIZE, 1000);

            //上下文处理
            setContext(userToken, paramMap, locale);

            Map<String, CellTypeContainer> headersTypeMap = HistoryDataConstant.getHeadersTypeMap(locale);
            Map<String, String> headersMap = HistoryDataConstant.getHeadersMap(locale);
            List<CellTypeContainer> businessKeyContainer = excelHelperV2.getBusinessKeyContainer(new ArrayList<>(headersTypeMap.values()));
            List<CellTypeContainer> arrayKeyContainer = excelHelperV2.getArrayKeyContainer(new ArrayList<>(headersTypeMap.values()));

            Set<String> arrayField = CollectionUtils.isEmpty(arrayKeyContainer)
                    ? new HashSet<>()
                    : arrayKeyContainer.stream()
                    .map(CellTypeContainer::getKeyName)
                    .collect(Collectors.toSet());

            exportProcessor.processExport(exportStatistics, workbook -> processAndCreateExcel(
                    paramMap, count, pageSize, locale, keyList, exportStatistics,
                    workbook, headersTypeMap, headersMap, businessKeyContainer, arrayField));
            exportStatistics.setUpdateTime(new Date());
            exportStatisticsDomainService.update(exportStatistics);
        } catch (Exception e) {
            log.error("ExportMQListener consume error:", e);
//            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
//            exportStatistics.setUpdateTime(new Date());
//            exportStatistics.setTotalSize(0);
//            exportStatisticsDomainService.updateById(exportStatistics);
            throw new RejectRetryException();
        }

        // 4、所有数据处理完毕，发送MQTT消息
//        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics(exportStatistics);
//        eventPublisher.publish(exportSuccessEvent);
    }

    private void setContext(String userToken, Map<String, Object> paramMap, String locale) {
        // userToken
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(userToken);
        } catch (Exception e) {
            log.error("解析token失败:{}", userToken);
            // 抛异常，在catch中统一处理
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0106.getErrCode(), MessageUtil.getMessage("delivery.resolveTokenError"), e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();

        // 查询用户信息，后续调外部接口时需要传routerKey
        AuthoredUser authoredUser = tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        //增加信任链减少中间件请求
        AppAuthContextHolder.getContext().setSecurityToken(userToken);

        ASKContext instance = ASKContext.getInstance();
        ASKContextEntity askContextEntity = new ASKContextEntity();
        askContextEntity.setArchiveRouteKey(MapUtils.getString(paramMap, "archiveRouteKey", ""));
        instance.set(askContextEntity);

        LocaleContextHolder.setLocale(JaI18nUtil.parseLocales(locale.replace('_', '-')));
    }

    private void processAndCreateExcel(Map<String, Object> paramMap, int count, int pageSize, String locale, List<String> keyList,
                                       ExportStatistics exportStatistics, SXSSFWorkbook sb, Map<String, CellTypeContainer> headersTypeMap,
                                       Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField) {

        int totalRecords = 0;
        if (paramMap != null && count > 0) {
            // 计算需要查询的批次数量
            int numberOfBatches = (count + pageSize - 1) / pageSize; // 向上取整

            for (int i = 0; i < numberOfBatches; i++) {
                // 设置分页参数
                paramMap.put("page", i + 1);
                paramMap.put("rows", pageSize);

                // 远程调用方式查询数据
                List<Map<String, Object>> data;
                Boolean isLocal = JaProperty.getBoolean(RedisQueueContant.IS_LOCAL, true);
                if (isLocal) {
                    //本地方法调用方式查出数据
                    data = findTaskBacklogHByLocal(paramMap, AppAuthContextHolder.getContext().getAuthoredUser());
                } else {
                    data = atmcService.findTaskBacklogH(paramMap, locale);
                }
                if (CollectionUtils.isEmpty(data)) {
                    break;
                }
                // 保持和Atheana平台展示内容一样的逻辑
                rebuildData(data, locale);

                // 累加查询到的产品数量
                totalRecords += data.size();

                // 2、创建并写入Excel数据
                long start = System.currentTimeMillis();
                excelHelperV2.createDataExcel(
                        "sheet",
                        exportStatistics.getLocale(),
                        2,
                        keyList,
                        headersTypeMap,
                        headersMap,
                        data,
                        sb,
                        businessKeyContainer,
                        0,
                        null,
                        null,
                        arrayField
                );
                log.info("新版本写入execl耗时：{}", System.currentTimeMillis() - start);

                // 如果查询结果小于pageSize，说明已经查询完毕
                if (data.size() < pageSize || totalRecords >= count) {
                    break;
                }
            }
        }
        exportStatistics.setTotalSize(totalRecords);
        JaLog.info("export total size :{}", totalRecords);
    }

    private List<Map<String, Object>> findTaskBacklogHByLocal(Map<String, Object> paramMap, AuthoredUser authoredUser) {
        IPage<TaskBacklogHistoryDTO> taskBacklogH = historyService.findTaskBacklogH(authoredUser, paramMap);
        List<TaskBacklogHistoryDTO> list = taskBacklogH.getRecords();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List<Map<String, Object>> data = JsonUtils.jsonToObject(JsonUtils.objectToString(list), new TypeReference<List<Map<String, Object>>>() {
        });
        return data;
    }
}

