package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;

import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.function.Consumer;

/**
 * 导出execl基础类
 */
@Component
@Slf4j
public class ExportProcessor {
    @Autowired
    public ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    public ExcelHelperV2 excelHelperV2;

    public void processExport(ExportStatistics exportStatistics, Consumer<SXSSFWorkbook> business) {
        //1、创建工作本
        SXSSFWorkbook workbook = createWorkbook();

        //2、前置参数获取,渲染数据到execl中
        //3、分页处理数据
        business.accept(workbook);
        List<ExportBatchRecord> exportBatchRecords = exportStatistics.getExportBatchRecords();
        if(CollectionUtils.isNotEmpty(exportBatchRecords)){
            // 开始进行拆分
            int numberOfSheets = workbook.getNumberOfSheets();
            boolean hasError = false;
            int total = 0;
            for (int i = 0; i < exportBatchRecords.size(); i++) {
                String fileUrl = null;
                ExportBatchRecord exportBatchRecord = exportBatchRecords.get(i);
                try {
                    SXSSFWorkbook destWorkbook = createWorkbook(); // 内存中保留 100 行
                    int num ;
                    if(i<numberOfSheets){
                        String sheetName = workbook.getSheetName(i);
                        num = ExcelHelperV2.cloneSheet(workbook, destWorkbook, sheetName);
                    }else {
                        num = 0;
                    }
                    fileUrl = download(destWorkbook, exportBatchRecord.getFileName(), exportStatistics.getExpireTime(),exportBatchRecord.getFileName()+".xlsx");
                    num = num-1;
                    if(num>0){
                        exportBatchRecord.setTotalSize(num);
                        total+=num;
                    }
                }catch (Exception e){
                    log.error("拆分excel失败:{}",e.getMessage(),e);
                    hasError = true;
                }
                if (!StringUtils.isEmpty(fileUrl)) {
                    exportBatchRecord.setFileUrl(fileUrl);
                    exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
                } else {
                    exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
                }

            }
            try {
                if(hasError){
                    exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
                }else {
                    exportStatistics.setTotalSize(total);
                    exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
                }
            }finally {
                workbook.dispose();
            }
        }else {
            String fileUrl = download(workbook, exportStatistics.getFileName(),exportStatistics.getExpireTime(),null);
            if (!StringUtils.isEmpty(fileUrl)) {
                exportStatistics.setFileUrl(fileUrl);
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("fileUrl is null!");
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
        }
    }



    protected SXSSFWorkbook createWorkbook() {
        return excelHelperV2.createSXSSFWorkbook();
    }

    protected String download(SXSSFWorkbook workbook, String fileName, Date expireTime,String excelName) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(fileName);
        fileInfo.setExpireDate(TimeUtils.format(expireTime, TimeUtils.DEFAULT_FORMAT));
        fileInfo.setFileName(excelName);
        return exportStatisticsDomainService.handleDownloadBaseDataV2(workbook, fileInfo);
    }
}
