package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
//import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import io.jsonwebtoken.lang.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author yanyn
 */
@RestController
@RequestMapping
public class EnvController {
    @Autowired
    EnvProperties envProperties;

    /**
     * 返回环境参数
     */
    @GetMapping(value = {"/api/env"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> getRuntimeEnv() {
        envProperties.refresh();
        return ResponseEntity.ok(envProperties);
    }

    @GetMapping(value = {"/test"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> test() {
        return ResponseEntity.ok("新的代码分成版本");
    }

//    @GetMapping("/db/mxbean")
//    public String mxbean() {
//        Set<Map.Entry<String, DataSource>> dataSources = JaDataSourceFactory.get().entrySet();
//        if (Collections.isEmpty(dataSources)) {
//            return "all dataSource is null";
//        }
//        StringBuffer resultBuffer = new StringBuffer();
//        for (Map.Entry<String, DataSource> entry : dataSources) {
//            String dataSourceKey = entry.getKey();
//            DataSource dataSource = entry.getValue();
//            if (dataSource == null) {
//                return dataSourceKey + " dataSource is null";
//            }
//            HikariDataSource hikariDataSource = (HikariDataSource) dataSource;
//            HikariPoolMXBean poolMXBean = hikariDataSource.getHikariPoolMXBean();
//            if (poolMXBean == null) {
//                return dataSourceKey + " poolMXBean is null";
//            }
//            int active = poolMXBean.getActiveConnections();
//            int idle = poolMXBean.getIdleConnections();
//            int total = poolMXBean.getTotalConnections();
//            String result = "[" + dataSourceKey + "]:" + "active:" + active + " idle:" + idle + " total:" + total;
//            resultBuffer.append(result + "\n");
//        }
//        return resultBuffer.toString();
//    }
}
