package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @description:
 * @author: xusj
 * @date: 2023/8/22 13:36
 */
@Slf4j
@Controller
@RequestMapping(value = "/api/test/ptm")
public class EventMqTestController {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    /**
     * 模拟 PTM 消息推送
     * @param data
     * @param user
     * @return
     */
    @Deprecated
    @PostMapping(value = "/mq/send", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> mockMqSend(@RequestBody String data,
                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_MQ_QUEUE_NAME, data);
        return ResponseEntity.ok(data);
    }
}
