package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.api.DapResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.abt.application.service.abt.migration.inout.HistoryProjectTaskServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 历史项目/任务
 *
 * @author xuhx
 * @date 2025/5/16
 */
@RestController
@RequestMapping("/api/abt/v1/historyProjectTask")
//@CrossOrigin
@Slf4j
public class HistoryProjectTaskInterface {

    @Autowired
    HistoryProjectTaskServiceImpl historyProjectTaskService;

    /**
     * 发起下载 历史项目/任务明细
     *
     * @param downloadHistoryProjectTaskParamDTO
     * @return
     */
    @PostMapping("/startDownloadHistoryData")
    public DapResponse startDownloadHistoryData(@RequestBody DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO) {
        return DapResponse.ok(historyProjectTaskService.startDownloadHistoryData(downloadHistoryProjectTaskParamDTO));
    }
}
