package com.digiwin.athena.abt.presentation.server.web;


import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEGrayModeEnum;
import com.digiwin.athena.abt.core.ie.dto.ExportTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.UUID;

@RestController
@RequestMapping("/api/abt/v1/ieenv")
//@CrossOrigin
@Slf4j
public class IEEnvController {

    @Autowired
    private ConfigurableEnvironment environment;

    private final static String IE_ENV_GRAY = "ie_env_gray";

    @Autowired
    private IEService exportService;


    @GetMapping("/test")
    public ResponseEntity test() {
        String tenantId = "123";
        String mainTaskId = UUID.randomUUID().toString();
        String taskType = IEExportTaskTypeEnum.EXPORT.getType();
        String businessType = IEExportBusinessTypeEnum.HISTORY.getType();

        IERedisMainTask mainTask = new IERedisMainTask();
        mainTask.setMainTaskId(mainTaskId);
        mainTask.setTaskType(taskType);
        mainTask.setReceiveTime(new Date());

        IERedisSubTask ieRedisTask = new IERedisSubTask();
        ieRedisTask.setSubTaskId(UUID.randomUUID().toString());
        ieRedisTask.setTenantId(tenantId);
        ieRedisTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
        ieRedisTask.setMainTaskId(mainTaskId);
        ieRedisTask.setBusinessType(businessType);
        ieRedisTask.setReceiveTime(new Date());
        ieRedisTask.setTaskClazz(ExportTask.class.getName());

        IERedisSubTask ieRedisTask2 = new IERedisSubTask();
        ieRedisTask2.setSubTaskId(UUID.randomUUID().toString());
        ieRedisTask2.setTenantId(tenantId);
        ieRedisTask2.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
        ieRedisTask2.setMainTaskId(mainTaskId);
        ieRedisTask2.setBusinessType(businessType);
        ieRedisTask2.setReceiveTime(new Date());
        ieRedisTask2.setTaskClazz(ExportTask.class.getName());

        mainTask.setSubTaskList(Lists.newArrayList(ieRedisTask,ieRedisTask2));


        exportService.submit(mainTask);

        return ResponseEntity.ok("ok");
    }

    @PostMapping("/setEnv")
    public ResponseEntity setGrayEnv(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (!"127.0.0.1".equals(remoteAddr) && !"0:0:0:0:0:0:0:1".equals(remoteAddr)) {
            return ResponseEntity.status(403).body("禁止访问: 仅允许本地调用");
        }
        environment.getPropertySources().stream().filter(source -> source instanceof MapPropertySource).findFirst().ifPresent(source -> {
            (((MapPropertySource) source).getSource()).put(IE_ENV_GRAY, IEGrayModeEnum.INCLUDE.getType());
        });
        String value = environment.getProperty(IE_ENV_GRAY);
        log.info("ie_env_gray value:{}", value);
        return ResponseEntity.ok("设置成功,ie_env_gray=" + value);
    }

    @PostMapping("/delEnv")
    public ResponseEntity delGrayEnv(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (!"127.0.0.1".equals(remoteAddr) && !"0:0:0:0:0:0:0:1".equals(remoteAddr)) {
            return ResponseEntity.status(403).body("禁止访问: 仅允许本地调用");
        }
        environment.getPropertySources().stream().filter(source -> source instanceof MapPropertySource).findFirst().ifPresent(source -> {
            (((MapPropertySource) source).getSource()).remove(IE_ENV_GRAY);
        });
        String value = environment.getProperty(IE_ENV_GRAY);
        log.info("ie_env_gray value:{}", value);
        return ResponseEntity.ok("清除成功,ie_env_gray=" + value);
    }

}
