package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DapResponse;

import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.dto.request.UploadBatchFileReq;
import com.digiwin.athena.abt.application.dto.request.UploadBatchReq;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryRedisService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.utils.JsonToMd5Converter;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;

import com.digiwin.athena.appcore.exception.BusinessException;

import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 改造后导入接口
 *
 * @author wzq
 */
@RestController
@RequestMapping("/api/abt/v2/baseDataEntry")
//@CrossOrigin
@Slf4j
public class ImportBasicDataController {

    @Autowired
    private BaseDataEntryRedisService baseDataEntryRedisService;

    @PostMapping("/uploadBatch")
    @ResponseBody
    public DapResponse uploadBatch(@RequestBody UploadBatchReq uploadBatchReq) {
        if (CollectionUtils.isEmpty(uploadBatchReq.getFiles())) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0078.getErrCode(), MessageUtil.getMessage("delivery.fileEmpty"));
        }
        Map<Integer, UploadBatchFileReq> fileUidMap = JsonToMd5Converter.getFileUids(uploadBatchReq);

        baseDataEntryRedisService.checkUploadParams(uploadBatchReq, fileUidMap);

        baseDataEntryRedisService.uploadBatch(uploadBatchReq, fileUidMap);
        return DapResponse.ok(MessageUtil.getMessage("delivery.success"));
    }

    @Autowired
    private ErrorHandlerService errorHandlerService;

    @Autowired
    private DMCConfig dmcConfig;

    @PostMapping("/uploadBatch/test")
    @ResponseBody
    public DapResponse uploadBatchTest(@RequestParam String actionId,
                                       @RequestParam String activityId,
                                       @RequestParam Integer isReImport,
                                       MultipartFile[] files,
                                       @RequestParam(required = false) String actionInfo,
                                       @RequestParam(required = false) Set<String> requiredFields) {
        UploadBatchReq uploadBatchReq = new UploadBatchReq();
        uploadBatchReq.setIsReImport(isReImport);
        uploadBatchReq.setActionId(actionId);
        uploadBatchReq.setActivityId(activityId);
        uploadBatchReq.setActionInfo(actionInfo);
        uploadBatchReq.setRequiredFields(requiredFields);


        List<UploadBatchFileReq> list = new ArrayList<>();
        for (int i = 0; i < files.length; i++) {
            MultipartFile file = files[i];
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName(file.getOriginalFilename());
            fileInfo.setDirectoryId(dmcConfig.getErrorTableUUID());
            String url = errorHandlerService.upload(file, fileInfo);
            UploadBatchFileReq uploadBatchFileReq = new UploadBatchFileReq();
            uploadBatchFileReq.setFileUrl(url);
            uploadBatchFileReq.setFileName(file.getOriginalFilename());
            uploadBatchFileReq.setCheckSum(JaUUID.UUID19());
            list.add(uploadBatchFileReq);
        }
        uploadBatchReq.setFiles(list);
        uploadBatch(uploadBatchReq);
        return DapResponse.ok(uploadBatchReq);
    }

    @PostMapping("/uploadFile/test")
    @ResponseBody
    public DapResponse uploadFileTest(MultipartFile[] files) {
        UploadBatchReq uploadBatchReq = new UploadBatchReq();
        List<UploadBatchFileReq> list = new ArrayList<>();
        for (int i = 0; i < files.length; i++) {
            MultipartFile file = files[i];
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName(file.getOriginalFilename());
            fileInfo.setDirectoryId(dmcConfig.getErrorTableUUID());
            String url = errorHandlerService.upload(file, fileInfo);
            UploadBatchFileReq uploadBatchFileReq = new UploadBatchFileReq();
            uploadBatchFileReq.setFileUrl(url);
            uploadBatchFileReq.setFileName(file.getOriginalFilename());
            uploadBatchFileReq.setCheckSum(JaUUID.UUID19());
            list.add(uploadBatchFileReq);
        }
        uploadBatchReq.setFiles(list);
        return DapResponse.ok(uploadBatchReq);
    }

}
