package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.api.NoticeAbtRepairDto;
import com.digiwin.athena.abt.application.service.abt.migration.repair.NoticeRepairApcDataService;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author lzw
 * @date 2024/2/29
 * @description:
 **/
@Slf4j
@RestController
@RequestMapping("/api/abt/v1/notice")
public class NoticeRepairApcDataCotroller {

    @Autowired
    private NoticeRepairApcDataService noticeRepairApcDataService;

    @PostMapping("/repairData")
    public ResponseEntity<?> repairApcData(@RequestBody NoticeAbtRepairDto dto, @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        log.info("通知abt修复APC数据接口入参：{}",dto);
        noticeRepairApcDataService.repairApcData(dto,user);

        return ResponseEntityWrapper.wrapperOk();
    }
}
