package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.atdm.util.MessageUtil;
import com.digiwin.athena.atdm.OpenHistoryProjectTaskServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 历史项目/任务
 *
 * @author xuhx
 * @date 2025/5/15
 */
@RestController
@RequestMapping("/historyProjectTask")
//@CrossOrigin
@Slf4j
public class OpenHistoryProjectTaskInterface {
    @Autowired
    OpenHistoryProjectTaskServiceImpl historyProjectTaskService;

    /**
     * 发起下载
     * 历史项目任务明细
     *
     * @param downloadHistoryProjectTaskParamDTO
     * @return
     */
    @PostMapping("/startDownloadHistoryData")
    public DapResponse startDownloadHistoryData(@RequestBody DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO) {
        if (Boolean.TRUE.equals(historyProjectTaskService.startDownloadHistoryData(downloadHistoryProjectTaskParamDTO))) {
            return DapResponse.ok();
        } else {
            return DapResponse.failed(MessageUtil.getMessage("delivery.exportDataError"));
        }
    }
}
