package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RequestMapping("/api/abt/v1/job")
@RestController
public class QuartzJobController {
    @Autowired
    private JobManager jobManager;

    @GetMapping("/triggerJob/{jobName}/{jobGroup}")
    public ResponseEntity<?> triggerJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        jobManager.runOnce(jobName,jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/pauseScheduleJob/{jobName}/{jobGroup}")
    public ResponseEntity<?> pauseScheduleJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        jobManager.pauseScheduleJob(jobName,jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/resumeScheduleJob/{jobName}/{jobGroup}")
    public ResponseEntity<?> resumeScheduleJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        jobManager.resumeScheduleJob(jobName,jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/getDetailJobData/{jobName}/{jobGroup}")
    public ResponseEntity<?> getDetailJobData(@PathVariable String jobName, @PathVariable String jobGroup) {
        return ResponseEntityWrapper.wrapperOk(jobManager.getDetailJobData(jobName,jobGroup));
    }
    @DeleteMapping("/delJob/{jobName}/{group}")
    public ResponseEntity<?> delJob(@PathVariable String jobName,@PathVariable String group) {
        jobManager.deleteJob(jobName,group);
        return ResponseEntityWrapper.wrapperOk();
    }

}
