package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshBkDTO;
import com.digiwin.athena.abt.application.service.abt.migration.bk.RefreshBkService;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 刷新bk
 */
@RestController
@RequestMapping("/api/abt/v1/refresh/bk")
@Slf4j
public class RefreshBkController {

    @Autowired
    private RefreshBkService refreshBkService;

    @PostMapping("/project")
    public ResponseEntity<?> repairApcData(@RequestBody RefreshBkDTO refreshBkDTO,
                                           @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        log.info("修复项目bk入参：{}", JsonUtils.objectToString(refreshBkDTO));
        return ResponseEntityWrapper.wrapperOk(refreshBkService.refreshProjectBk(refreshBkDTO.getProjectIds(), refreshBkDTO.getTenantId(), user));
    }

    /**
     * 校验入参projectIds对应的BK是否存在，并返回不存在对应BK的projectId列表
     *
     * @param refreshBkDTO
     * @param user
     * @return
     */
    @PostMapping("/check/project/bk/exist")
    public ResponseEntity<?> checkProjectBKExist(@RequestBody RefreshBkDTO refreshBkDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        log.info("检查项目bk入参：{}", JsonUtils.objectToString(refreshBkDTO));
        return ResponseEntityWrapper.wrapperOk(refreshBkService.checkProjectBKExist(refreshBkDTO.getProjectIds(), refreshBkDTO.getTenantId(), user));
    }


    @PostMapping("/task/bk")
    public ResponseEntity<?> repairTaskBkData(@RequestBody RefreshBkDTO refreshBkDTO,
                                           @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        log.info("修复任务bk入参：{}", JsonUtils.objectToString(refreshBkDTO));
        return ResponseEntityWrapper.wrapperOk(refreshBkService.refreshTaskBk(refreshBkDTO.getWorkItemList(), refreshBkDTO.getTenantId(), user));
    }

    @PostMapping("/csv/upload")
    public ResponseEntity<?> upload(@RequestPart("file") MultipartFile file,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        refreshBkService.upload(file, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/check/task/bk/exist")
    public ResponseEntity<?> queryBkByWorkItemId(@RequestBody RefreshBkDTO refreshBkDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(refreshBkService.queryBkByWorkItemId(refreshBkDTO.getTenantId(), refreshBkDTO.getWorkItemIdList(),
                user));
    }

    @PostMapping("/check/task/bk/repair")
    public ResponseEntity<?> checkNeedRepair(@RequestBody RefreshBkDTO refreshBkDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(refreshBkService.checkNeedRepair(refreshBkDTO.getTenantId(), refreshBkDTO.getWorkItemIdList(),
                user));
    }



}
