package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.task.SharingTaskDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.ShareService;
import com.digiwin.athena.abt.core.meta.constants.SharingTaskConstant;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @Author mk
 * @Date 2025/05/22 14:55
 * @Description: 分享
 * @Version 1.0
 */
@RestController
@RequestMapping("/api/abt/v1/share")
@Validated
public class ShareController {
    @Autowired
    private ShareService shareService;

    /**
     * 获取分享码内容
     */
    @GetMapping("/getShareCodeCache")
    public ResponseEntity<?> getShareCodeCache(@Valid @RequestParam("sharingCode") @NotBlank @Pattern(regexp = SharingTaskConstant.SHARING_CODE_VALUE_REGEX) String sharingCode) {
        return ResponseEntityWrapper.wrapperOk(shareService.getShareCodeCache(sharingCode));
    }
}
