package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.core.ie.redis.RedisTaskQueueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping
public class TaskMonitorController {

    @Autowired
    protected RedisTaskQueueService redisTaskQueueService;

    /**
     * 获取运行中的导入导出任务
     *
     * @return
     */
    @GetMapping(value = {"/api/task/running"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> getRunning() {

        List<String> list = redisTaskQueueService.getRunning();
        return ResponseEntity.ok(list);
    }

    /**
     * 获取待运行的导入导出任务
     *
     * @return
     */
    @GetMapping(value = {"/api/task/waiting"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> getWaiting() {
        List<String> list = redisTaskQueueService.getWaiting();
        return ResponseEntity.ok(list);
    }


}
