/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.excel.ExcelParserBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.DMCTokenBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.application.utils.LockPoolDataEntryHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DataEntryListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryListener.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ImportStatisticsDomainService importStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    @Qualifier(value="rabbitErrorHandlerServiceImpl")
    ErrorHandlerService errorHandlerService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Resource
    RestTemplate dmcRestTemplate;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Value(value="${dmc.uri}")
    private String dmcUrl;
    @Value(value="${athena.auth.appToken}")
    private String appToken;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryApplicationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"#{dataEntryQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    public void consumer(String msg) {
        DataEntryTask dataEntryTask = (DataEntryTask)JsonUtils.jsonToObject((String)msg, DataEntryTask.class);
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(dataEntryTask.getMasterId());
        ImportBatchRecord importBatchRecord = this.importStatisticsDomainService.getBatchRecordByPIdAndSeq(dataEntryTask.getMasterId(), dataEntryTask.getBatchNum());
        if (null == importStatistics || null == importBatchRecord) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},batchNum:{},importStatistics:{},importBatchRecord:{}", new Object[]{dataEntryTask.getMasterId(), dataEntryTask.getBatchNum(), importStatistics, importBatchRecord});
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        Integer processingNum = importStatistics.getProcessingNum();
        if (!StringUtils.isEmpty((String)importStatistics.getRouterKey())) {
            MDC.put((String)"routerKey", (String)importStatistics.getRouterKey());
        }
        if (importBatchRecord.getHandleFlag() == 1) {
            log.error("\u6570\u636e\u5df2\u7ecf\u5904\u7406masterId:{},batchNum:{}", (Object)dataEntryTask.getMasterId(), (Object)dataEntryTask.getBatchNum());
            return;
        }
        int lockId = LockPoolDataEntryHelper.getIdByUUID((String)dataEntryTask.getMasterId(), (int)this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        lock.lock();
        try {
            DWSecurityToken dwSecurityToken;
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)dataEntryTask.getUserToken());
            }
            catch (Exception e) {
                log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)dataEntryTask.getUserToken());
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
            }
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(importStatistics.getActionId(), dwSecurityContext.getUserToken(), dataEntryTask.getLocale(), dataEntryTask.getUserToken());
            ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(metadataDTO, dataEntryTask.getActionInfo());
            List cellTypes = this.metaDataService.getCellTypeContainers(mainMetadata.getField(), authoredUser.getToken(), null, dataEntryTask.getLocale(), 1);
            boolean createErrorQueueFlag = importStatistics.getFailedNum() == 0;
            ArrayList errorList = new ArrayList();
            List validateErrorList = this.metaDataService.validateByBatch(dataEntryTask, cellTypes);
            if (CollectionUtils.isEmpty((Collection)validateErrorList)) {
                EspResponse response = this.sendByBatch(dataEntryTask);
                if (response.isOK()) {
                    this.importStatisticsFactory.calBySucceededNum(dataEntryTask.getDataList().size(), importStatistics, importBatchRecord);
                    this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
                } else {
                    List importErrorResult;
                    if (null == response.getData()) {
                        log.error("\u8c03\u7528esp\u670d\u52a1\u5931\u8d25");
                        importErrorResult = this.batchError(dataEntryTask.getKeyList(), dataEntryTask.getDataList());
                    } else {
                        importErrorResult = this.importStatisticsFactory.parseResponse(dataEntryTask.getTableKey(), response);
                    }
                    if (Objects.isNull(importErrorResult)) {
                        log.error("\u8c03\u7528esp\u670d\u52a1\uff0c\u89e3\u6790\u5bfc\u5165\u5f02\u5e38\u6570\u636e\u5931\u8d25!");
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0107.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.handleDataError", (Object[])new Object[0]));
                    }
                    this.importStatisticsFactory.calByTotalAndFailNum(dataEntryTask.getDataList().size(), importErrorResult.size(), importStatistics, importBatchRecord);
                    this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
                    errorList.addAll(importErrorResult);
                }
            } else {
                this.importStatisticsFactory.calByTotalAndFailNum(dataEntryTask.getDataList().size(), validateErrorList.size(), importStatistics, importBatchRecord);
                this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
                errorList.addAll(validateErrorList);
            }
            if (!CollectionUtils.isEmpty(errorList)) {
                try {
                    this.errorHandlerService.handleErrorList(importStatistics, errorList, createErrorQueueFlag);
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u5931\u8d25\u6570\u636e\u5931\u8d25", (Throwable)e);
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0107.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.handleDataError", (Object[])new Object[0]));
                }
            }
            if (importStatistics.getProcessingNum() == 0 && importStatistics.getFailedNum() > 0) {
                String mainKeyDescription;
                Map metaData = this.metaDataService.getHeaderMap(mainMetadata);
                Map cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), importStatistics.getUserToken(), dataEntryTask.getLocale());
                String mainKey = metadataDTO.getResponse().getData().getData_name();
                String failedUrl = this.errorHandlerService.onImportFinish(ExcelHelper.getSheetName((String)mainKey, (String)(mainKeyDescription = metadataDTO.getResponse().getData().getDescription()), (Boolean)true), dataEntryTask.getKeyList(), cellTypeContainerMap, metaData, importStatistics);
                if (!StringUtils.isEmpty((String)failedUrl)) {
                    importStatistics.setFailedUrl(failedUrl);
                    this.importStatisticsDomainService.updateById(importStatistics);
                } else {
                    log.error("failedUrl is null!");
                }
            }
        }
        catch (Exception e) {
            if (Objects.equals(importStatistics.getProcessingNum(), processingNum)) {
                this.importStatisticsFactory.calErrorNum(dataEntryTask.getDataList().size(), importStatistics, importBatchRecord);
                this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
            }
            log.error("DataEntryListener consume error:{}", (Throwable)e);
        }
        finally {
            lock.unlock();
            if (!StringUtils.isEmpty((String)importStatistics.getRouterKey())) {
                MDC.remove((String)"routerKey");
            }
        }
        if (importStatistics.getProcessingNum() == 0) {
            ImportSuccessEvent importSuccessEvent = ImportSuccessEventFactory.produceByImportStatistics((ImportStatistics)importStatistics);
            this.eventPublisher.publish(importSuccessEvent);
        }
    }

    @RabbitListener(queues={"#{dataEntryQueueNameAsync}"}, ackMode="AUTO")
    @RabbitHandler
    public void consumerAsync(String msg) {
        UploadParamDTO UploadParam = (UploadParamDTO)JsonUtils.jsonToObject((String)msg, UploadParamDTO.class);
        ExcelParserBean excelParserBean = new ExcelParserBean();
        InputStream fileInputStream = this.getFileInputStream(UploadParam.getFileUrl());
        excelParserBean.setInput(fileInputStream);
        excelParserBean.setFilePath(UploadParam.getFileName());
        this.baseDataEntryApplicationService.upload(UploadParam, excelParserBean);
    }

    private InputStream getFileInputStream(String fileUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.parseMediaType((String)ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + fileUrl;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"#{dataEntryDeadLetterQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    @Transactional(rollbackFor={Exception.class})
    public void handleDeadLetter(String msg) {
        DataEntryTask dataEntryTask = (DataEntryTask)JsonUtils.jsonToObject((String)msg, DataEntryTask.class);
        ImportStatistics importStatistics = this.importStatisticsDomainService.getByMasterId(dataEntryTask.getMasterId());
        ImportBatchRecord importBatchRecord = this.importStatisticsDomainService.getBatchRecordByPIdAndSeq(dataEntryTask.getMasterId(), dataEntryTask.getBatchNum());
        if (null == importStatistics || null == importBatchRecord) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},batchNum:{}", (Object)dataEntryTask.getMasterId(), (Object)dataEntryTask.getBatchNum());
            return;
        }
        if (!StringUtils.isEmpty((String)importStatistics.getRouterKey())) {
            MDC.put((String)"routerKey", (String)importStatistics.getRouterKey());
        }
        try {
            DWSecurityToken dwSecurityToken;
            boolean createQueueFlag;
            boolean bl = createQueueFlag = importStatistics.getFailedNum() == 0;
            if (importBatchRecord.getHandleFlag() == 1) {
                log.error("\u6570\u636e\u5df2\u7ecf\u5904\u7406masterId:{},batchNum:{}", (Object)dataEntryTask.getMasterId(), (Object)dataEntryTask.getBatchNum());
                return;
            }
            List importErrorResult = this.batchError(dataEntryTask.getKeyList(), dataEntryTask.getDataList());
            this.importStatisticsFactory.calByTotalAndFailNum(dataEntryTask.getDataList().size(), importErrorResult.size(), importStatistics, importBatchRecord);
            this.importStatisticsDomainService.updateThisAndBatchRecordsById(importStatistics);
            LinkedList errorList = new LinkedList();
            errorList.addAll(importErrorResult);
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)dataEntryTask.getUserToken());
            }
            catch (Exception e) {
                log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)dataEntryTask.getUserToken());
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0108.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
            }
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(importStatistics.getActionId(), dwSecurityContext.getUserToken(), dataEntryTask.getLocale(), dataEntryTask.getUserToken());
            ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(metadataDTO, dataEntryTask.getActionInfo());
            Map metaData = this.metaDataService.getHeaderMap(mainMetadata);
            if (!CollectionUtils.isEmpty(errorList)) {
                try {
                    this.errorHandlerService.handleErrorList(importStatistics, errorList, createQueueFlag);
                }
                catch (IOException e) {
                    log.error("error handleErrorList", (Throwable)e);
                }
            }
            if (importStatistics.getProcessingNum() == 0) {
                String mainKeyDescription;
                Map cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), importStatistics.getUserToken(), dataEntryTask.getLocale());
                String mainKey = metadataDTO.getResponse().getData().getData_name();
                String failedUrl = this.errorHandlerService.onImportFinish(ExcelHelper.getSheetName((String)mainKey, (String)(mainKeyDescription = metadataDTO.getResponse().getData().getDescription()), (Boolean)true), dataEntryTask.getKeyList(), cellTypeContainerMap, metaData, importStatistics);
                if (!StringUtils.isEmpty((String)failedUrl)) {
                    importStatistics.setFailedUrl(failedUrl);
                    this.importStatisticsDomainService.updateById(importStatistics);
                }
                ImportSuccessEvent importSuccessEvent = ImportSuccessEventFactory.produceByImportStatistics((ImportStatistics)importStatistics);
                this.eventPublisher.publish(importSuccessEvent);
            }
        }
        finally {
            if (!StringUtils.isEmpty((String)importStatistics.getRouterKey())) {
                MDC.remove((String)"routerKey");
            }
        }
    }

    private List<Map<String, Object>> batchError(List<String> keyList, List<Map> dataList) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        dataList.forEach(item -> {
            HashMap<String, String> row = new HashMap<String, String>(item.size() * 2);
            row.putAll((Map<String, String>)item);
            row.put("batch_error_msg", MessageUtil.getMessage((String)"delivery.batchHandleError", (Object[])new Object[0]));
            result.add(row);
        });
        return result;
    }

    public EspResponse sendByBatch(DataEntryTask dataEntryTask) {
        DWSecurityToken dwSecurityToken;
        String actionId = dataEntryTask.getActionId();
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)dataEntryTask.getUserToken());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)dataEntryTask.getUserToken());
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0109.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        GetActionLocaleResponseDTO metaData = this.metaDataService.getActionMetaDataBySecurityToken(actionId, dwSecurityContext.getUserToken(), dataEntryTask.getUserToken());
        String productName = this.metaDataService.getProductNameBySecurityToken(dwSecurityContext.getUserToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0), dataEntryTask.getUserToken());
        return this.espService.sendByBatch(dataEntryTask, metaData, dataEntryTask.getDataList(), productName);
    }

    private List<Map> formTable(List<String> tableFields, List<List<Object>> table) {
        LinkedList<Map> result = new LinkedList<Map>();
        table.forEach(item -> {
            HashMap entity = new HashMap();
            AtomicInteger idx = new AtomicInteger();
            item.forEach(inner -> {
                entity.put(tableFields.get(idx.get()), inner);
                idx.getAndIncrement();
            });
            result.add(entity);
        });
        return result;
    }
}

