/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventListenerService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
public class EventListener
extends EventBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventListener.class);
    @Autowired
    private EventListenerService eventListenerService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.message.abt", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.message.abt"})}, concurrency="#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('athena.event.message.abt')}")
    @RabbitRetry(beforeHandler="ptmMqBeforeHandler", successHander="ptmMqSuccessHandler", failureHandler="ptmMqFailureHandler")
    public void receiveOrder(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Header(value="retry-count", required=false) Integer retryCount) {
        super.receiveOrder(data, "athena.event.message.abt", channel, tag, retryCount);
    }

    public void processMessage(String data, EventListenerDTO eventListenerDTO) {
        log.info("[athena.event.message.abt-data]: processMessage data = {}, eventListener = {}", (Object)data, (Object)JsonUtils.objectToString((Object)eventListenerDTO));
        this.eventListenerService.processMsg(data, eventListenerDTO);
        log.info("\u6d88\u8d39ptm\u6d88\u606f\u6210\u529f\uff08atmc\u8f6c\u53d1\uff09");
    }
}

