/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.exception.RejectRetryException;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.abt.presentation.mq.ExportProcessor;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExportBasicDataRedisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportBasicDataRedisListener.class);
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private EspService espService;
    @Autowired
    private BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Resource
    private ExportBatchRecordMapper recordMapper;
    @Autowired
    private ExportProcessor exportProcessor;
    @Autowired
    private ExcelHelperV2 excelHelperV2;

    public void consumer(ExportFileMsg exportFileMsg) {
        log.info("basicdata consumer masterId:{}", (Object)exportFileMsg.getMasterId());
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},exportStatistics:{}", (Object)exportFileMsg.getMasterId(), (Object)exportStatistics);
            return;
        }
        try {
            ExportBatchRecord cp;
            String actionId = exportFileMsg.getActionId();
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();
            DWSecurityContext dwSecurityContext = this.setContext(userToken);
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(actionId, dwSecurityContext.getUserToken(), locale, userToken);
            DownloadBaseDataParamDTO downloadBaseDataParamDTO = exportFileMsg.getDownloadBaseDataParamDTO();
            this.baseDataEntryService.getActionParas(downloadBaseDataParamDTO);
            exportFileMsg.setApplication(downloadBaseDataParamDTO.getApplication());
            exportFileMsg.setType(exportStatistics.getType());
            String productName = this.metaDataService.getProductName(dwSecurityContext.getUserToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0));
            String mainKey = metadataDTO.getResponse().getData().getData_name();
            String mainKeyDesc = metadataDTO.getResponse().getData().getDescription();
            Map headersTypeMap = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), userToken, locale);
            ArrayList keyList = new ArrayList();
            Map headers = this.metaDataService.getResponseHeaders(metadataDTO, keyList);
            this.baseDataEntryService.getExportFileds(downloadBaseDataParamDTO.getActionInfo().getSelectField(), keyList, headersTypeMap);
            String sheetName = ExcelHelperV2.getSheetName((String)mainKey, (String)mainKeyDesc, (Boolean)true);
            List businessKeyContainer = this.excelHelperV2.getBusinessKeyContainer(new ArrayList(headersTypeMap.values()));
            List arrayKeyContainer = this.excelHelperV2.getArrayKeyContainer(new ArrayList(headersTypeMap.values()));
            HashSet arrayField = CollectionUtils.isEmpty((Collection)arrayKeyContainer) ? new HashSet() : arrayKeyContainer.stream().map(CellTypeContainer::getKeyName).collect(Collectors.toSet());
            List batchRecordPOList = this.recordMapper.listByMasterId(exportStatistics.getMasterId(), null);
            if (!CollectionUtils.isEmpty((Collection)batchRecordPOList)) {
                ArrayList exportBatchRecordList = Lists.newArrayListWithExpectedSize((int)batchRecordPOList.size());
                for (ExportBatchRecordPO exportBatchRecordPO : batchRecordPOList) {
                    cp = (ExportBatchRecord)JaBeanCopy.cp((Object)exportBatchRecordPO, ExportBatchRecord.class);
                    exportBatchRecordList.add(cp);
                }
                exportStatistics.setExportBatchRecords((List)exportBatchRecordList);
            }
            if (Boolean.TRUE.equals(this.metaDataService.useHasNext(metadataDTO))) {
                Integer pageNum = ImportAndExportStatisticsConstants.EXPORT_FILE_DEFAULT_PAGE_NO;
                this.exportProcessor.processExport(exportStatistics, workbook -> this.getBaseDataByPage(downloadBaseDataParamDTO.getActionInfo().getCategory(), exportStatistics, sheetName, workbook, keyList, headersTypeMap, headers, businessKeyContainer, arrayField, downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, mainKey, dwSecurityContext.getUserToken(), pageNum));
            } else {
                this.exportProcessor.processExport(exportStatistics, workbook -> this.getBaseData(downloadBaseDataParamDTO.getActionInfo().getCategory(), exportStatistics, sheetName, workbook, keyList, headersTypeMap, headers, businessKeyContainer, arrayField, downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, mainKey, dwSecurityContext.getUserToken()));
            }
            if (!CollectionUtils.isEmpty((Collection)exportStatistics.getExportBatchRecords())) {
                List exportBatchRecords = exportStatistics.getExportBatchRecords();
                for (ExportBatchRecord exportBatchRecord : exportBatchRecords) {
                    cp = (ExportBatchRecordPO)JaBeanCopy.cp((Object)exportBatchRecord, ExportBatchRecordPO.class);
                    cp.setUpdateTime(new Date());
                    this.recordMapper.updateById((Object)cp);
                }
            }
            exportStatistics.setUpdateTime(new Date());
            JaLog.info((String)"has been export records size: {}", (Object[])new Object[]{exportStatistics.getTotalSize()});
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        catch (Exception e) {
            log.error("ExportMQListener consume error:{}", (Object)e.getMessage(), (Object)e);
            throw new RejectRetryException();
        }
    }

    private DWSecurityContext setContext(String userToken) {
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)userToken);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        return dwSecurityContext;
    }

    private void getBaseDataByPage(String category, ExportStatistics exportStatistics, String sheetName, SXSSFWorkbook sb, List<String> keyList, Map<String, CellTypeContainer> headersTypeMap, Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField, Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String mainKey, String userToken, Integer pageNum) {
        requestParam.put("use_has_next", true);
        requestParam.put("page_size", JaProperty.getInteger((String)"athena.export.redis-queue.base.page-size", (Integer)500));
        requestParam.put("page_no", pageNum);
        Boolean hasNext = this.getBaseData(category, exportStatistics, sheetName, sb, keyList, headersTypeMap, headersMap, businessKeyContainer, arrayField, requestParam, exportFileMsg, productName, mainKey, userToken);
        if (Boolean.TRUE.equals(hasNext)) {
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            this.getBaseDataByPage(category, exportStatistics, sheetName, sb, keyList, headersTypeMap, headersMap, businessKeyContainer, arrayField, requestParam, exportFileMsg, productName, mainKey, userToken, pageNum);
        }
    }

    private Boolean getBaseData(String category, ExportStatistics exportStatistics, String sheetName, SXSSFWorkbook sb, List<String> keyList, Map<String, CellTypeContainer> headersTypeMap, Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField, Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String mainKey, String userToken) {
        int limit;
        int currentSize;
        EspResponse espResponse = this.espService.getBaseData(requestParam, exportFileMsg, productName, userToken);
        if (Objects.isNull(espResponse) || !espResponse.isOK()) {
            log.error("getBaseData fail! exportFileMsg:{}", (Object)exportFileMsg);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0067.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.exportDataError", (Object[])new Object[0]));
        }
        EspBody espBody = (EspBody)espResponse.getData();
        if (Objects.isNull(espBody) || Objects.isNull(espBody.getStd_data()) || CollectionUtils.isEmpty((Map)espBody.getStd_data().getParameter()) || Objects.isNull(espBody.getStd_data().getParameter().get(mainKey))) {
            log.error("getBaseData espResponse is null! exportFileMsg:{}", (Object)exportFileMsg);
            return false;
        }
        Boolean hasNext = espBody.getStd_data().getParameter().containsKey("has_next") ? (Boolean)espBody.getStd_data().getParameter().get("has_next") : Boolean.valueOf(false);
        List tableList = (List)espBody.getStd_data().getParameter().get(mainKey);
        int totalSize = exportStatistics.getTotalSize();
        if (totalSize + (currentSize = CollectionUtils.isEmpty((Collection)tableList) ? 0 : tableList.size()) > (limit = JaProperty.getInteger((String)"athena.export.redis-queue.base.limit-size", (Integer)2000).intValue()) && "DOUBLE-DOCUMENT".equals(category)) {
            int retainSize = limit - totalSize;
            if (retainSize > 0 && retainSize < currentSize) {
                tableList = tableList.subList(0, retainSize);
                hasNext = false;
            } else if (retainSize <= 0) {
                tableList = Collections.emptyList();
                hasNext = false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableList)) {
            this.excelHelperV2.createDataExcel(sheetName, exportFileMsg.getLocale(), 2, keyList, headersTypeMap, headersMap, tableList, (Workbook)sb, businessKeyContainer, 0, null, null, arrayField);
            exportStatistics.setTotalSize(Integer.valueOf(exportStatistics.getTotalSize() + tableList.size()));
        }
        return hasNext;
    }
}

