/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.utils.LockPoolDataEntryHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.HistoryDataConstant;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.presentation.mq.ExportHistoryDataParentService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExportHistoryDataMQListener
extends ExportHistoryDataParentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportHistoryDataMQListener.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private AtmcService atmcService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"#{exportHistoryDataFileQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    public void consumer(String msg) {
        ExportFileMsg exportFileMsg = (ExportFileMsg)JsonUtils.jsonToObject((String)msg, ExportFileMsg.class);
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},exportStatistics:{}", (Object)exportFileMsg.getMasterId(), (Object)exportStatistics);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        Date now = new Date();
        int lockId = LockPoolDataEntryHelper.getIdByUUID((String)exportFileMsg.getMasterId(), (int)this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        lock.lock();
        try {
            DWSecurityToken dwSecurityToken;
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)userToken);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
            }
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            Map param = exportFileMsg.getHistoryDownloadBaseDataParam();
            Map paramMap = MapUtils.getMap((Map)param, (Object)"searchInfo", null);
            ArrayList list = new ArrayList();
            this.getList(list, param, paramMap, locale);
            Map historydDataInfo = MapUtils.getMap((Map)param, (Object)"historydDataInfo", null);
            List keyList = new ArrayList();
            if (null != historydDataInfo && historydDataInfo.containsKey("selectField")) {
                keyList = (List)MapUtils.getObject((Map)historydDataInfo, (Object)"selectField");
            }
            long start = System.currentTimeMillis();
            String fileUrl = this.exportStatisticsDomainService.handleDownloadBaseData(exportStatistics, keyList, HistoryDataConstant.getHeadersMap((String)locale), HistoryDataConstant.getHeadersTypeMap((String)locale), list, "sheet");
            log.info("\u8001\u7248\u672c\u5199\u5165execl\u548c\u4e0a\u4f20\u6587\u4ef6\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            if (!StringUtils.isEmpty((String)fileUrl)) {
                exportStatistics.setFileUrl(fileUrl);
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("fileUrl is null!");
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
            exportStatistics.setUpdateTime(new Date());
            JaLog.info((String)"export total size :{}", (Object[])new Object[]{list.size()});
            exportStatistics.setTotalSize(Integer.valueOf(list.size()));
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        catch (Exception e) {
            log.error("ExportMQListener consume error:{}", (Throwable)e);
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportStatistics.setUpdateTime(new Date());
            exportStatistics.setTotalSize(Integer.valueOf(0));
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        finally {
            lock.unlock();
        }
        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics((ExportStatistics)exportStatistics);
        this.eventPublisher.publish(exportSuccessEvent);
    }

    private List<Map<String, Object>> getList(List<Map<String, Object>> list, Map<String, Object> param, Map<String, Object> paramMap, String locale) {
        int count = MapUtils.getIntValue(param, (Object)"count", (int)0);
        if (null != paramMap && count > 0) {
            int pageSize = 500;
            int totalRecords = 0;
            int numberOfBatches = (count + pageSize - 1) / pageSize;
            for (int i = 0; i < numberOfBatches; ++i) {
                paramMap.put("page", i + 1);
                paramMap.put("rows", pageSize);
                List data = this.atmcService.findTaskBacklogH(paramMap, locale);
                if (CollectionUtils.isEmpty((Collection)data)) break;
                this.rebuildData(data, locale);
                list.addAll(data);
                if (data.size() < pageSize || (totalRecords += data.size()) >= count) break;
            }
        }
        return list;
    }
}

