/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ExportHistoryDataParentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportHistoryDataParentService.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    MessageUtils messageUtils;

    public void rebuildData(List<Map<String, Object>> data, String locale) {
        for (Map<String, Object> map : data) {
            Integer performerType = MapUtils.getInteger(map, (Object)"performerType", null);
            String state = MapUtils.getString(map, (Object)"state", (String)"");
            String backlogTaskName = MapUtils.getString(map, (Object)"backlogTaskName", (String)"");
            String historyMessage = MapUtils.getString(map, (Object)"historyMessage", (String)"");
            String type = MapUtils.getString(map, (Object)"type", (String)"");
            String oldPerformerName = MapUtils.getString(map, (Object)"oldPerformerName", (String)"");
            String directionPerformerName = MapUtils.getString(map, (Object)"directionPerformerName", (String)"");
            Integer sourceState = MapUtils.getInteger(map, (Object)"sourceState", (Integer)0);
            Integer directionState = MapUtils.getInteger(map, (Object)"directionState", (Integer)0);
            String typeDesc = "";
            String stateDesc = "";
            String nameDesc = "";
            String source = "";
            String operate = "";
            if ("1".equals(type)) {
                typeDesc = this.messageUtils.getMessageByLangName("export.history.type.task", locale);
                source = this.buildTaskSource(sourceState, source, oldPerformerName, locale);
                operate = this.buildTaskDirectionState(directionState, operate, directionPerformerName, locale);
            }
            if ("0".equals(type)) {
                typeDesc = this.messageUtils.getMessageByLangName("export.history.type.project", locale);
                source = this.buildProjectSource(sourceState, source, oldPerformerName, locale);
                operate = this.messageUtils.getMessageByLangName("export.history.operate.system", locale);
            }
            map.put("source", source);
            map.put("operate", operate);
            map.put("type", typeDesc);
            if ("0".equals(state)) {
                String endTime = MapUtils.getString(map, (Object)"endTime", (String)"");
                String closedTime = MapUtils.getString(map, (Object)"closedTime", (String)"");
                HashMap timeMap = new HashMap();
                if (StringUtils.isNotEmpty((String)endTime) && StringUtils.isNotEmpty((String)closedTime)) {
                    ExportHistoryDataParentService.calculateTime(timeMap, (String)endTime, (String)closedTime);
                }
                long days = MapUtils.getLongValue(timeMap, (Object)"days", (long)0L);
                long hours = MapUtils.getLongValue(timeMap, (Object)"hours", (long)0L);
                long minutes = MapUtils.getLongValue(timeMap, (Object)"minutes", (long)0L);
                if (days > 0L) {
                    stateDesc = String.format(this.messageUtils.getMessageByLangName("export.history.state.overtime.day", locale), days);
                } else if (hours > 0L) {
                    stateDesc = String.format(this.messageUtils.getMessageByLangName("export.history.state.overtime.hour", locale), hours);
                } else if (minutes > 0L) {
                    stateDesc = String.format(this.messageUtils.getMessageByLangName("export.history.state.overtime.minute", locale), minutes);
                }
            } else {
                stateDesc = this.messageUtils.getMessageByLangName("export.history.state.punctual", locale);
            }
            map.put("state", stateDesc);
            String name = MapUtils.getString(map, (Object)"name", (String)"");
            nameDesc = null != performerType ? (performerType.equals(1) ? String.format(this.messageUtils.getMessageByLangName("export.history.working.agent", locale), name) : (performerType.equals(998) ? String.format(this.messageUtils.getMessageByLangName("export.history.dj.agent", locale), name) : name)) : name;
            map.put("name", nameDesc);
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)historyMessage)) {
                String[] historyMessageArr = historyMessage.split("<br>");
                for (int i = 0; i < historyMessageArr.length && i <= 9; ++i) {
                    sb.append(historyMessageArr[i]).append("\n");
                }
            } else {
                String summary = MapUtils.getString(map, (Object)"summary", (String)"");
                if (StringUtils.isNotEmpty((String)summary)) {
                    String[] summaryArr = summary.split("<br>");
                    for (int i = 0; i < summaryArr.length && i <= 9; ++i) {
                        sb.append(summaryArr[i]).append("\n");
                    }
                }
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                sb.deleteCharAt(sb.length() - 1);
            }
            map.put("backlogTaskName", sb.toString());
            String projectStartAndEndTime = "";
            Boolean merge = MapUtils.getBoolean(map, (Object)"merge", (Boolean)false);
            String dataFrom = MapUtils.getString(map, (Object)"dataFrom", (String)"");
            if (!BooleanUtils.isTrue((Boolean)merge) || !"PTM".equals(dataFrom)) {
                String projectStartTime = this.getDateStr(MapUtils.getString(map, (Object)"projectStartTime", (String)""));
                String projectEndTime = this.getDateStr(MapUtils.getString(map, (Object)"projectEndTime", (String)""));
                projectStartAndEndTime = StringUtils.isNotBlank((String)projectStartTime) && StringUtils.isNotBlank((String)projectEndTime) ? projectStartTime + "-" + projectEndTime : projectStartAndEndTime;
            }
            map.put("projectStartAndEndTime", projectStartAndEndTime);
            this.rebuildDateTime(map);
        }
    }

    public String buildProjectSource(Integer sourceState, String source, String oldPerformerName, String locale) {
        if (StringUtils.isNotEmpty((String)oldPerformerName)) {
            switch (sourceState) {
                case 0: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.system", locale), oldPerformerName);
                    break;
                }
                case 1: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.transfer", locale), oldPerformerName);
                    break;
                }
                case 3: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.handover", locale), oldPerformerName);
                    break;
                }
            }
        } else {
            switch (sourceState) {
                case 0: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.system", locale);
                    break;
                }
                case 1: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.transfer", locale);
                    break;
                }
                case 3: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.handover", locale);
                    break;
                }
            }
        }
        return source;
    }

    public String buildTaskDirectionState(Integer directionState, String operate, String directionPerformerName, String locale) {
        if (StringUtils.isNotEmpty((String)directionPerformerName)) {
            switch (directionState) {
                case 0: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.system", locale), directionPerformerName);
                    break;
                }
                case 1: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.transfer", locale), directionPerformerName);
                    break;
                }
                case 2: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.return", locale), directionPerformerName);
                    break;
                }
                case 3: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.return", locale), directionPerformerName);
                    break;
                }
                case 4: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.countersignature", locale), directionPerformerName);
                    break;
                }
                case 9: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.withdraw", locale), directionPerformerName);
                    break;
                }
                case 10: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.to.handover", locale), directionPerformerName);
                    break;
                }
                case 99: {
                    operate = String.format(this.messageUtils.getMessageByLangName("export.history.operate.from.stop", locale), directionPerformerName);
                    break;
                }
            }
        } else {
            switch (directionState) {
                case 0: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.system", locale);
                    break;
                }
                case 1: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.transfer", locale);
                    break;
                }
                case 2: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.return", locale);
                    break;
                }
                case 3: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.return", locale);
                    break;
                }
                case 4: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.countersignature", locale);
                    break;
                }
                case 9: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.withdraw", locale);
                    break;
                }
                case 10: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.handover", locale);
                    break;
                }
                case 99: {
                    operate = this.messageUtils.getMessageByLangName("export.history.operate.stop", locale);
                    break;
                }
            }
        }
        return operate;
    }

    public String buildTaskSource(Integer sourceState, String source, String oldPerformerName, String locale) {
        if (StringUtils.isNotEmpty((String)oldPerformerName)) {
            switch (sourceState) {
                case 0: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.system", locale), oldPerformerName);
                    break;
                }
                case 1: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.transfer", locale), oldPerformerName);
                    break;
                }
                case 2: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.return", locale), oldPerformerName);
                    break;
                }
                case 3: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.return", locale), oldPerformerName);
                    break;
                }
                case 4: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.countersignature", locale), oldPerformerName);
                    break;
                }
                case 9: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.withdraw", locale), oldPerformerName);
                    break;
                }
                case 10: {
                    source = String.format(this.messageUtils.getMessageByLangName("export.history.source.from.handover", locale), oldPerformerName);
                    break;
                }
            }
        } else {
            switch (sourceState) {
                case 0: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.system", locale);
                    break;
                }
                case 1: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.transfer", locale);
                    break;
                }
                case 2: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.return", locale);
                    break;
                }
                case 3: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.return", locale);
                    break;
                }
                case 4: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.countersignature", locale);
                    break;
                }
                case 9: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.withdraw", locale);
                    break;
                }
                case 10: {
                    source = this.messageUtils.getMessageByLangName("export.history.source.handover", locale);
                    break;
                }
            }
        }
        return source;
    }

    public void rebuildDateTime(Map<String, Object> map) {
        String endTime = MapUtils.getString(map, (Object)"endTime", (String)"");
        String startTime = MapUtils.getString(map, (Object)"startTime", (String)"");
        String closedTime = MapUtils.getString(map, (Object)"closedTime", (String)"");
        String createTime = MapUtils.getString(map, (Object)"createTime", (String)"");
        if (StringUtils.isNotEmpty((String)endTime)) {
            String endTimeStr = DateUtil.format((Date)DateUtil.parse((CharSequence)endTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy/MM/dd HH:mm:ss");
            map.put("endTime", endTimeStr);
        }
        if (StringUtils.isNotEmpty((String)startTime)) {
            String startTimeStr = DateUtil.format((Date)DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy/MM/dd HH:mm:ss");
            map.put("startTime", startTimeStr);
        }
        if (StringUtils.isNotEmpty((String)closedTime)) {
            String closedTimeStr = DateUtil.format((Date)DateUtil.parse((CharSequence)closedTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy/MM/dd HH:mm:ss");
            map.put("closedTime", closedTimeStr);
        }
        if (StringUtils.isNotEmpty((String)createTime)) {
            String createTimeStr = DateUtil.format((Date)DateUtil.parse((CharSequence)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy/MM/dd HH:mm:ss");
            map.put("createTime", createTimeStr);
        }
    }

    public static void calculateTime(Map<String, Long> timeMap, String endTimeString, String closedTimeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime closedTime = LocalDateTime.parse(closedTimeString, formatter);
        LocalDateTime endTime = LocalDateTime.parse(endTimeString, formatter);
        Duration duration = Duration.between(endTime, closedTime);
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        timeMap.put("days", days);
        timeMap.put("hours", hours);
        timeMap.put("minutes", minutes);
    }

    public String getDateStr(String dateString) {
        if (StringUtils.isEmpty((String)dateString)) {
            return "";
        }
        DateTime date = DateUtil.parse((CharSequence)dateString, (String)"yyyy-MM-dd HH:mm:ss");
        String formattedDateString = DateUtil.format((Date)date, (String)"yyyy/MM/dd");
        return formattedDateString;
    }
}

