/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.history.TaskBacklogHistoryService;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.exception.RejectRetryException;
import com.digiwin.athena.abt.core.meta.constants.HistoryDataConstant;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.presentation.mq.ExportHistoryDataParentService;
import com.digiwin.athena.abt.presentation.mq.ExportProcessor;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.core.context.ASKContext;
import com.digiwin.athena.framework.core.context.ASKContextEntity;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExportHistoryDataRedisListener
extends ExportHistoryDataParentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportHistoryDataRedisListener.class);
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private ExcelHelperV2 excelHelperV2;
    @Autowired
    private ExportProcessor exportProcessor;
    @Autowired
    private TaskBacklogHistoryService historyService;

    public void consumer(ExportFileMsg exportFileMsg) {
        log.info("history consumer masterId:{}", (Object)exportFileMsg.getMasterId());
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},exportStatistics:{}", (Object)exportFileMsg.getMasterId(), (Object)exportStatistics);
            return;
        }
        try {
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();
            Map param = exportFileMsg.getHistoryDownloadBaseDataParam();
            Map paramMap = MapUtils.getMap((Map)param, (Object)"searchInfo", null);
            List keyList = Optional.ofNullable(MapUtils.getMap((Map)param, (Object)"historydDataInfo", null)).map(map -> (List)map.get("selectField")).orElseGet(ArrayList::new);
            int count = MapUtils.getIntValue((Map)param, (Object)"count", (int)0);
            int pageSize = JaProperty.getInteger((String)"athena.export.redis-queue.history.page-size", (Integer)1000);
            this.setContext(userToken, paramMap, locale);
            Map headersTypeMap = HistoryDataConstant.getHeadersTypeMap((String)locale);
            Map headersMap = HistoryDataConstant.getHeadersMap((String)locale);
            List businessKeyContainer = this.excelHelperV2.getBusinessKeyContainer(new ArrayList(headersTypeMap.values()));
            List arrayKeyContainer = this.excelHelperV2.getArrayKeyContainer(new ArrayList(headersTypeMap.values()));
            HashSet arrayField = CollectionUtils.isEmpty((Collection)arrayKeyContainer) ? new HashSet() : arrayKeyContainer.stream().map(CellTypeContainer::getKeyName).collect(Collectors.toSet());
            this.exportProcessor.processExport(exportStatistics, workbook -> this.processAndCreateExcel(paramMap, count, pageSize, locale, keyList, exportStatistics, workbook, headersTypeMap, headersMap, businessKeyContainer, arrayField));
            exportStatistics.setUpdateTime(new Date());
            this.exportStatisticsDomainService.update(exportStatistics);
        }
        catch (Exception e) {
            log.error("ExportMQListener consume error:", (Throwable)e);
            throw new RejectRetryException();
        }
    }

    private void setContext(String userToken, Map<String, Object> paramMap, String locale) {
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)userToken);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        AppAuthContextHolder.getContext().setSecurityToken(userToken);
        ASKContext instance = ASKContext.getInstance();
        ASKContextEntity askContextEntity = new ASKContextEntity();
        askContextEntity.setArchiveRouteKey(MapUtils.getString(paramMap, (Object)"archiveRouteKey", (String)""));
        instance.set(askContextEntity);
        LocaleContextHolder.setLocale((Locale)JaI18nUtil.parseLocales((String)locale.replace('_', '-')));
    }

    private void processAndCreateExcel(Map<String, Object> paramMap, int count, int pageSize, String locale, List<String> keyList, ExportStatistics exportStatistics, SXSSFWorkbook sb, Map<String, CellTypeContainer> headersTypeMap, Map<String, String> headersMap, List<CellTypeContainer> businessKeyContainer, Set<String> arrayField) {
        int totalRecords = 0;
        if (paramMap != null && count > 0) {
            int numberOfBatches = (count + pageSize - 1) / pageSize;
            for (int i = 0; i < numberOfBatches; ++i) {
                paramMap.put("page", i + 1);
                paramMap.put("rows", pageSize);
                Boolean isLocal = JaProperty.getBoolean((String)"athena.export.redis-queue.history.local.enable", (Boolean)true);
                List data = isLocal != false ? this.findTaskBacklogHByLocal(paramMap, AppAuthContextHolder.getContext().getAuthoredUser()) : this.atmcService.findTaskBacklogH(paramMap, locale);
                if (CollectionUtils.isEmpty((Collection)data)) break;
                this.rebuildData(data, locale);
                long start = System.currentTimeMillis();
                this.excelHelperV2.createDataExcel("sheet", exportStatistics.getLocale(), 2, keyList, headersTypeMap, headersMap, data, (Workbook)sb, businessKeyContainer, 0, null, null, arrayField);
                log.info("\u65b0\u7248\u672c\u5199\u5165execl\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                if (data.size() < pageSize || (totalRecords += data.size()) >= count) break;
            }
        }
        exportStatistics.setTotalSize(Integer.valueOf(totalRecords));
        JaLog.info((String)"export total size :{}", (Object[])new Object[]{totalRecords});
    }

    private List<Map<String, Object>> findTaskBacklogHByLocal(Map<String, Object> paramMap, AuthoredUser authoredUser) {
        IPage taskBacklogH = this.historyService.findTaskBacklogH(authoredUser, paramMap);
        List list = taskBacklogH.getRecords();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List data = (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)list), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return data;
    }
}

