/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.event.ttl.ExportMQListenerInterface;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.uibot.UibotService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="exportHistoryProjectTaskDetailMQListener")
public class ExportHistoryProjectTaskDetailMQListener
implements ExportMQListenerInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportHistoryProjectTaskDetailMQListener.class);
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    private ExcelHelper excelHelper;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private UibotService uibotService;
    @Autowired
    private ExportBatchRecordMapper exportBatchRecordMapper;
    @Autowired
    private DMCConfig dmcConfig;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    @Qualifier(value="rabbitErrorHandlerServiceImpl")
    private ErrorHandlerService errorHandlerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"#{exportHistoryProjectTaskDetailQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    public void consumer(String msg) {
        ExportFileMsg exportFileMsg = (ExportFileMsg)JsonUtils.jsonToObject((String)msg, ExportFileMsg.class);
        String masterId = exportFileMsg.getMasterId();
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(masterId);
        if (exportStatistics == null) {
            log.error("ExportHistoryProjectTaskDetailMQListener\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{}", (Object)masterId);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        ExportBatchRecord exportBatchRecord = exportFileMsg.getExportBatchRecord();
        Long exportBatchRecordId = exportBatchRecord.getId();
        Integer batchSeq = exportBatchRecord.getBatchSeq();
        Date date = new Date();
        ExportBatchRecordPO exportBatchRecordPO = new ExportBatchRecordPO();
        exportBatchRecordPO.setId(exportBatchRecordId);
        exportBatchRecordPO.setUpdateTime(date);
        try {
            String fileId;
            ExportBatchRecordPO existingRecord = this.exportBatchRecordMapper.queryByMasterIdAndBatchSeq(masterId, batchSeq);
            if (existingRecord != null && existingRecord.getState() == 1) {
                return;
            }
            String userToken = exportFileMsg.getUserToken();
            DWSecurityToken token = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
            DWSecurityContext context = token.getContext();
            AuthoredUser user = this.tokenVerifyService.getUserInfo(context.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            AppAuthContextHolder.getContext().setProxyToken(exportBatchRecord.getProxyToken());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("backlogId", exportBatchRecord.getRelate());
            Map dataResult = this.uibotService.dataByBacklogIdAndState(paramMap);
            List tableList = Optional.ofNullable(dataResult).map(data -> (List)data.get("data")).map(data -> (List)JSON.parseObject((String)JSON.toJSONString((Object)data), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).orElse(Collections.emptyList());
            String actionId = Optional.ofNullable(dataResult.get("actionId")).map(Object::toString).orElse(null);
            if (StringUtils.isBlank((String)actionId)) {
                throw new BusinessException("actionId\u4e3a\u7a7a,exportBatchRecordId:" + exportBatchRecordId);
            }
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(actionId, context.getUserToken(), exportFileMsg.getLocale(), userToken);
            String mainKey = metadataDTO.getResponse().getData().getData_name();
            String mainKeyDesc = metadataDTO.getResponse().getData().getDescription();
            Map cellTypes = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, context.getUserToken(), userToken, exportFileMsg.getLocale());
            ArrayList keyList = new ArrayList();
            Map headers = this.metaDataService.getResponseHeaders(metadataDTO, keyList);
            if (tableList.size() > ImportAndExportStatisticsConstants.EXPORT_LIMIT) {
                tableList = tableList.subList(0, ImportAndExportStatisticsConstants.EXPORT_LIMIT);
            }
            if (StringUtils.isNotEmpty((String)(fileId = this.handleDownloadHistoryProjectTask(exportBatchRecord.getFileName(), exportFileMsg.getLocale(), exportStatistics.getExpireTime(), ExcelHelper.getSheetName((String)mainKey, (String)mainKeyDesc, (Boolean)true), keyList, headers, cellTypes, tableList)))) {
                exportBatchRecordPO.setFileUrl(fileId);
                exportBatchRecordPO.setTotalSize(Integer.valueOf(tableList.size()));
                exportBatchRecordPO.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("ExportHistoryProjectTaskDetailMQListener\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25masterId:{}, exportBatchRecordId:{}", (Object)masterId, (Object)exportBatchRecordId);
                exportBatchRecordPO.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
                exportBatchRecordPO.setRemark("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            log.error("ExportHistoryProjectTaskDetailMQListener\u5bfc\u51fa\u5904\u7406\u5f02\u5e38exportBatchRecordId:" + exportBatchRecordId + ", error:", (Throwable)e);
            exportBatchRecordPO.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportBatchRecordPO.setRemark(e.getMessage());
        }
        finally {
            String name;
            String type;
            switch (type = Optional.ofNullable(exportBatchRecord.getType()).orElse("default")) {
                case "2": {
                    name = this.themeMapService.getTaskNamesByCodes(exportBatchRecord.getCode());
                    break;
                }
                case "3": {
                    name = this.themeMapService.getProjectNamesByCodes(exportBatchRecord.getCode());
                    break;
                }
                default: {
                    name = this.metaDataService.getActivityNameByActivityId(exportBatchRecord.getCode(), null);
                }
            }
            exportBatchRecordPO.setName(name);
            this.exportBatchRecordMapper.updateById((Object)exportBatchRecordPO);
        }
        this.updateExportStatistics(exportStatistics, exportBatchRecordId);
    }

    private void updateExportStatistics(ExportStatistics exportStatistics, Long exportBatchRecordId) {
        try {
            List batchList = this.exportBatchRecordMapper.listByMasterId(exportStatistics.getMasterId(), null);
            long failedCount = batchList.stream().filter(r -> ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL.equals(r.getState())).count();
            boolean hasProcessing = batchList.stream().anyMatch(r -> ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING.equals(r.getState()));
            if (!hasProcessing) {
                int newState = ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS;
                if (failedCount > 0L) {
                    newState = failedCount == (long)exportStatistics.getTotalSize().intValue() ? ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL : ImportAndExportStatisticsConstants.EXPROT_STATE_ABNORMAL;
                }
                exportStatistics.setState(Integer.valueOf(newState));
                exportStatistics.setFailedSize(Integer.valueOf((int)failedCount));
                exportStatistics.setUpdateTime(new Date());
                this.exportStatisticsDomainService.updateById(exportStatistics);
                ExportSuccessEvent event = ExportSuccessEventFactory.produceByExportStatistics((ExportStatistics)exportStatistics);
                this.eventPublisher.publish(event);
            }
        }
        catch (Exception e) {
            log.error("ExportHistoryProjectTaskDetailMQListener,updateExportStatistics\u66f4\u65b0exportStatistics\u5f02\u5e38exportBatchRecordId:" + exportBatchRecordId + ", error:", (Throwable)e);
        }
    }

    private String handleDownloadHistoryProjectTask(String fileName, String locale, Date expireTime, String sheetName, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap, List<Map<String, Object>> tableList) {
        MockMultipartFile multipartFile;
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            XSSFWorkbook xssfwb = new XSSFWorkbook();
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                xssfwb.write((OutputStream)bos);
            }
            catch (IOException e) {
                log.error("handleDownloadHistoryProjectTask\u8f6c\u6362multipartfile\u5931\u8d25:", (Throwable)e);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadHistoryProjectTask\u8f6c\u6362multipartFile\u5931\u8d25:", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        log.error("handleDownloadHistoryProjectTask Exception occurred:", (Throwable)e);
                    }
                }
            }
            SXSSFWorkbook sxssfwb = new SXSSFWorkbook(xssfwb, ImportAndExportStatisticsConstants.SXSSFWorkbook_MEMORY_SIZE.intValue());
            int rowIndex = 2;
            List businessKeyContainer = this.excelHelper.getBusinessKeyContainer(new ArrayList<CellTypeContainer>(cellTypeContainerMap.values()));
            this.excelHelper.createDataExcel(sheetName, locale, rowIndex, keyList, cellTypeContainerMap, headers, tableList, (Workbook)sxssfwb, businessKeyContainer, 0, null, null);
            outputStream = new ByteArrayOutputStream();
            sxssfwb.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            multipartFile = new MockMultipartFile("file", fileName, ExcelTypeEnum.XLSX.value(), inputStream);
            outputStream.flush();
            sxssfwb.dispose();
        }
        catch (Exception e) {
            log.error("handleDownloadHistoryProjectTask fail:", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0076.getErrCode(), (String)"handleDownloadHistoryProjectTask fail:", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("handleDownloadHistoryProjectTask close outputStream fail:", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("handleDownloadHistoryProjectTask close inputStream fail:", (Throwable)e);
                }
            }
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(fileName);
        fileInfo.setFileName(fileName + ".xlsx");
        fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
        fileInfo.setExpireDate(TimeUtils.format((Date)expireTime, (String)"yyyy-MM-dd HH:mm:ss"));
        return this.errorHandlerService.upload((MultipartFile)multipartFile, fileInfo);
    }

    @RabbitListener(queues={"#{exportHistoryProjectTaskDetailDeadLetterQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    public void deadLetterConsumer(String msg) {
        ExportFileMsg exportFileMsg = (ExportFileMsg)JsonUtils.jsonToObject((String)msg, ExportFileMsg.class);
        String masterId = exportFileMsg.getMasterId();
        try {
            String name;
            String type;
            ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(masterId);
            ExportBatchRecordPO exportBatchRecord = this.exportBatchRecordMapper.queryByMasterIdAndBatchSeq(masterId, exportFileMsg.getExportBatchRecord().getBatchSeq());
            if (exportStatistics == null || exportBatchRecord == null) {
                log.error("ExportHistoryProjectTaskDetail,deadLetterConsumer\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{}", (Object)masterId);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
            }
            String userToken = exportFileMsg.getUserToken();
            DWSecurityToken token = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
            DWSecurityContext context = token.getContext();
            AuthoredUser user = this.tokenVerifyService.getUserInfo(context.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(user);
            AppAuthContextHolder.getContext().setProxyToken(exportBatchRecord.getProxyToken());
            switch (type = Optional.ofNullable(exportBatchRecord.getType()).orElse("default")) {
                case "2": {
                    name = this.themeMapService.getTaskNamesByCodes(exportBatchRecord.getCode());
                    break;
                }
                case "3": {
                    name = this.themeMapService.getProjectNamesByCodes(exportBatchRecord.getCode());
                    break;
                }
                default: {
                    name = this.metaDataService.getActivityNameByActivityId(exportBatchRecord.getCode(), null);
                }
            }
            ExportBatchRecordPO exportBatchRecordPO = new ExportBatchRecordPO();
            exportBatchRecordPO.setId(exportBatchRecord.getId());
            exportBatchRecordPO.setName(name);
            exportBatchRecordPO.setUpdateTime(new Date());
            exportBatchRecordPO.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportBatchRecordPO.setRemark("\u6d88\u606f\u6d88\u8d39\u8d85\u65f6\uff0c\u8fdb\u5165\u6b7b\u4fe1\u961f\u5217\uff0c\u76f4\u63a5\u5931\u8d25");
            int i = this.exportBatchRecordMapper.updateById((Object)exportBatchRecordPO);
            if (i == 1) {
                this.updateExportStatistics(exportStatistics, exportBatchRecord.getId());
            }
        }
        catch (Exception e) {
            log.error("ExportHistoryProjectTaskDetail,deadLetterConsumer error,masterId:" + masterId, (Throwable)e);
        }
    }
}

