/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.event.ttl.ExportMQListenerInterface;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsFactory;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.application.utils.LockPoolDataEntryHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="exportMQListener")
public class ExportMQListener
implements ExportMQListenerInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportMQListener.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    EspService espService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    LockPool lockPool;
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    private TokenVerifyService tokenVerifyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"#{exportFileQueueName}"}, ackMode="AUTO")
    @RabbitHandler
    public void consumer(String msg) {
        ExportFileMsg exportFileMsg = (ExportFileMsg)JsonUtils.jsonToObject((String)msg, ExportFileMsg.class);
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{},exportStatistics:{}", (Object)exportFileMsg.getMasterId(), (Object)exportStatistics);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0060.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        int lockId = LockPoolDataEntryHelper.getIdByUUID((String)exportFileMsg.getMasterId(), (int)this.lockPool.getPoolSize());
        ReentrantLock lock = this.lockPool.getLockById(lockId);
        lock.lock();
        try {
            DWSecurityToken dwSecurityToken;
            String actionId = exportFileMsg.getActionId();
            String userToken = exportFileMsg.getUserToken();
            String locale = exportFileMsg.getLocale();
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)userToken);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790token\u5931\u8d25:{}", (Object)userToken);
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
            }
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(actionId, dwSecurityContext.getUserToken(), locale, userToken);
            DownloadBaseDataParamDTO downloadBaseDataParamDTO = exportFileMsg.getDownloadBaseDataParamDTO();
            this.baseDataEntryService.getActionParas(downloadBaseDataParamDTO);
            exportFileMsg.setApplication(downloadBaseDataParamDTO.getApplication());
            exportFileMsg.setType(exportStatistics.getType());
            List tableList = new ArrayList();
            String productName = this.metaDataService.getProductName(dwSecurityContext.getUserToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0));
            String mainKey = metadataDTO.getResponse().getData().getData_name();
            String mainKeyDesc = metadataDTO.getResponse().getData().getDescription();
            if (Boolean.TRUE.equals(this.metaDataService.useHasNext(metadataDTO))) {
                Integer pageNum = ImportAndExportStatisticsConstants.EXPORT_FILE_DEFAULT_PAGE_NO;
                this.getBaseDataByPage(downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, mainKey, dwSecurityContext.getUserToken(), pageNum, tableList);
            } else {
                this.getBaseData(downloadBaseDataParamDTO.getActionInfo().getActionParas(), exportFileMsg, productName, tableList, mainKey, dwSecurityContext.getUserToken());
            }
            Map cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), userToken, locale);
            ArrayList keyList = new ArrayList();
            Map headers = this.metaDataService.getResponseHeaders(metadataDTO, keyList);
            if (!CollectionUtils.isEmpty(tableList) && tableList.size() > ImportAndExportStatisticsConstants.EXPORT_LIMIT && "DOUBLE-DOCUMENT".equals(downloadBaseDataParamDTO.getActionInfo().getCategory())) {
                tableList = tableList.subList(0, ImportAndExportStatisticsConstants.EXPORT_LIMIT);
            }
            this.baseDataEntryService.getExportFileds(downloadBaseDataParamDTO.getActionInfo().getSelectField(), keyList, cellTypeContainerMap);
            String fileUrl = this.exportStatisticsDomainService.handleDownloadBaseData(exportStatistics, keyList, headers, cellTypeContainerMap, tableList, ExcelHelper.getSheetName((String)mainKey, (String)mainKeyDesc, (Boolean)true));
            if (!StringUtils.isEmpty((String)fileUrl)) {
                exportStatistics.setFileUrl(fileUrl);
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("fileUrl is null!");
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
            exportStatistics.setUpdateTime(new Date());
            JaLog.info((String)"has been export records size: {}", (Object[])new Object[]{tableList.size()});
            exportStatistics.setTotalSize(Integer.valueOf(tableList.size()));
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        catch (Exception e) {
            log.error("ExportMQListener consume error:{}", (Throwable)e);
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportStatistics.setUpdateTime(new Date());
            exportStatistics.setTotalSize(Integer.valueOf(0));
            this.exportStatisticsDomainService.updateById(exportStatistics);
        }
        finally {
            lock.unlock();
        }
        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics((ExportStatistics)exportStatistics);
        this.eventPublisher.publish(exportSuccessEvent);
    }

    private void getBaseDataByPage(Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String mainKey, String userToken, Integer pageNum, List<Map<String, Object>> tableList) {
        requestParam.put("use_has_next", true);
        requestParam.put("page_size", ImportAndExportStatisticsConstants.EXPORT_FILE_DEFAULT_PAGE_SIZE);
        requestParam.put("page_no", pageNum);
        Boolean hasNext = this.getBaseData(requestParam, exportFileMsg, productName, tableList, mainKey, userToken);
        if (Boolean.TRUE.equals(hasNext)) {
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            this.getBaseDataByPage(requestParam, exportFileMsg, productName, mainKey, userToken, pageNum, tableList);
        }
    }

    private Boolean getBaseData(Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, List<Map<String, Object>> tableList, String mainKey, String userToken) {
        EspResponse espResponse = this.espService.getBaseData(requestParam, exportFileMsg, productName, userToken);
        if (Objects.isNull(espResponse) || !espResponse.isOK()) {
            log.error("getBaseData fail! exportFileMsg:{}", (Object)exportFileMsg);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0067.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.exportDataError", (Object[])new Object[0]));
        }
        EspBody espBody = (EspBody)espResponse.getData();
        if (Objects.isNull(espBody) || Objects.isNull(espBody.getStd_data()) || CollectionUtils.isEmpty((Map)espBody.getStd_data().getParameter()) || Objects.isNull(espBody.getStd_data().getParameter().get(mainKey))) {
            log.error("getBaseData espResponse is null! exportFileMsg:{}", (Object)exportFileMsg);
            return false;
        }
        Boolean hasNext = espBody.getStd_data().getParameter().containsKey("has_next") ? (Boolean)espBody.getStd_data().getParameter().get("has_next") : Boolean.valueOf(false);
        tableList.addAll((List)espBody.getStd_data().getParameter().get(mainKey));
        return hasNext;
    }
}

