/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportProcessor.class);
    @Autowired
    public ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    public ExcelHelperV2 excelHelperV2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExport(ExportStatistics exportStatistics, Consumer<SXSSFWorkbook> business) {
        SXSSFWorkbook workbook = this.createWorkbook();
        business.accept(workbook);
        List exportBatchRecords = exportStatistics.getExportBatchRecords();
        if (CollectionUtils.isNotEmpty((Collection)exportBatchRecords)) {
            int numberOfSheets = workbook.getNumberOfSheets();
            boolean hasError = false;
            int total = 0;
            for (int i = 0; i < exportBatchRecords.size(); ++i) {
                String fileUrl = null;
                ExportBatchRecord exportBatchRecord = (ExportBatchRecord)exportBatchRecords.get(i);
                try {
                    int num;
                    SXSSFWorkbook destWorkbook = this.createWorkbook();
                    if (i < numberOfSheets) {
                        String sheetName = workbook.getSheetName(i);
                        num = ExcelHelperV2.cloneSheet((SXSSFWorkbook)workbook, (SXSSFWorkbook)destWorkbook, (String)sheetName);
                    } else {
                        num = 0;
                    }
                    fileUrl = this.download(destWorkbook, exportBatchRecord.getFileName(), exportStatistics.getExpireTime(), exportBatchRecord.getFileName() + ".xlsx");
                    if (--num > 0) {
                        exportBatchRecord.setTotalSize(Integer.valueOf(num));
                        total += num;
                    }
                }
                catch (Exception e) {
                    log.error("\u62c6\u5206excel\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                    hasError = true;
                }
                if (!StringUtils.isEmpty(fileUrl)) {
                    exportBatchRecord.setFileUrl(fileUrl);
                    exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
                    continue;
                }
                exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
            try {
                if (hasError) {
                    exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
                }
                exportStatistics.setTotalSize(Integer.valueOf(total));
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            }
            finally {
                workbook.dispose();
            }
        } else {
            String fileUrl = this.download(workbook, exportStatistics.getFileName(), exportStatistics.getExpireTime(), null);
            if (!StringUtils.isEmpty((String)fileUrl)) {
                exportStatistics.setFileUrl(fileUrl);
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS);
            } else {
                log.error("fileUrl is null!");
                exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            }
        }
    }

    protected SXSSFWorkbook createWorkbook() {
        return this.excelHelperV2.createSXSSFWorkbook();
    }

    protected String download(SXSSFWorkbook workbook, String fileName, Date expireTime, String excelName) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(fileName);
        fileInfo.setExpireDate(TimeUtils.format((Date)expireTime, (String)"yyyy-MM-dd HH:mm:ss"));
        fileInfo.setFileName(excelName);
        return this.exportStatisticsDomainService.handleDownloadBaseDataV2(workbook, fileInfo);
    }
}

