/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainCountInfoTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import com.digiwin.athena.abt.core.ie.strategy.AbstractIETaskStrategy;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.presentation.mq.ExportHistoryDataRedisListener;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.core.context.ASKContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class HistoryTaskStrategy
extends AbstractIETaskStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryTaskStrategy.class);
    @Autowired
    private ExportHistoryDataRedisListener exportHistoryDataRedisListener;
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private EventPublisher eventPublisher;

    public boolean supports(String businessType) {
        return IEExportBusinessTypeEnum.HISTORY.getType().equalsIgnoreCase(businessType);
    }

    public void doExecute(IERedisSubTask ieRedisTask) {
        log.info("------------>execute\u6267\u884c\u5386\u53f2\u4efb\u52a1:" + JsonUtils.objectToString((Object)ieRedisTask));
        AppAuthContextHolder.clearContext();
        ASKContext.getInstance().remove();
        LocaleContextHolder.resetLocaleContext();
        this.exportHistoryDataRedisListener.consumer((ExportFileMsg)ieRedisTask);
    }

    public void doSuccess(IERedisSubTask ieRedisTask) {
        ExportStatistics exportStatistics = this.getExportFileMsg((ExportFileMsg)ieRedisTask);
        if (exportStatistics == null) {
            return;
        }
        this.publisEvent(exportStatistics);
        log.info("=============>doSuccess,masterId:{}", (Object)exportStatistics.getMasterId());
    }

    public void doFail(IERedisSubTask ieRedisTask, Throwable throwable) {
        ExportStatistics exportStatistics = this.getExportFileMsg((ExportFileMsg)ieRedisTask);
        if (exportStatistics == null) {
            return;
        }
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
        exportStatistics.setUpdateTime(new Date());
        exportStatistics.setTotalSize(Integer.valueOf(0));
        this.exportStatisticsDomainService.update(exportStatistics);
        this.publisEvent(exportStatistics);
        log.error("=============>doFail,masterId:{}", (Object)exportStatistics.getMasterId(), (Object)throwable);
    }

    public void doTimeout(IERedisSubTask ieRedisTask) {
        ExportStatistics exportStatistics = this.getExportFileMsg((ExportFileMsg)ieRedisTask);
        if (exportStatistics == null) {
            return;
        }
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
        exportStatistics.setUpdateTime(new Date());
        exportStatistics.setTotalSize(Integer.valueOf(0));
        this.exportStatisticsDomainService.update(exportStatistics);
        this.publisEvent(exportStatistics);
        log.info("=============>doTimeout,masterId:{}", (Object)exportStatistics.getMasterId());
    }

    public void doAllComplete(IERedisMainCountInfoTask mainCoutInfoTask) {
        List list = mainCoutInfoTask.getInfo().getSubTaskIdList();
        log.info("=============>doAllComplete,masterId:{}", (Object)(CollectionUtils.isEmpty((Collection)list) ? "" : String.join((CharSequence)", ", list)));
    }

    private ExportStatistics getExportFileMsg(ExportFileMsg exportFileMsg) {
        ExportStatistics exportStatistics = this.exportStatisticsDomainService.getByMasterId(exportFileMsg.getMasterId());
        if (Objects.isNull(exportStatistics)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636emasterId:{}", (Object)exportFileMsg.getMasterId());
            return null;
        }
        return exportStatistics;
    }

    private void publisEvent(ExportStatistics exportStatistics) {
        ExportSuccessEvent exportSuccessEvent = ExportSuccessEventFactory.produceByExportStatistics((ExportStatistics)exportStatistics);
        this.eventPublisher.publish(exportSuccessEvent);
    }
}

