/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.MetadataContext;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.esp.EspService;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsDomainService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.MetaDataService;
import com.digiwin.athena.abt.application.utils.ConcurrentSubmitUtils;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.dto.ExeclCacheLog;
import com.digiwin.athena.abt.core.meta.dto.ImportCounters;
import com.digiwin.athena.abt.core.meta.dto.IndexOption;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.uiils.CounterContext;
import com.digiwin.athena.abt.core.uiils.MongoCacheUtils;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.google.common.base.Stopwatch;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ImportBasicDataRedisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportBasicDataRedisListener.class);
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private EspService espService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private ExcelHelperV2 excelHelperV2;
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    private ImportStatisticsDomainService importStatisticsDomainService;
    @Autowired
    private DynamicThreadPool taskExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumerBatch(DataEntryTask dataEntryTask) {
        ImportStatistics importStatistics = null;
        List importBatchRecords = null;
        SXSSFWorkbook errorWorkbook = null;
        String masterId = dataEntryTask.getMasterId();
        try {
            importStatistics = this.importStatisticsDomainService.queryImportStatisticsByMasterId(masterId);
            importBatchRecords = this.importStatisticsDomainService.queryImportBatchRecordsByMasterId(masterId);
            CounterContext.put((String)masterId, (ImportCounters)this.createCounters(importStatistics));
            MetadataContext metadataContext = this.initializeMetadataContext(dataEntryTask, importStatistics);
            Object workbookLock = new Object();
            errorWorkbook = this.excelHelperV2.createSXSSFWorkbook();
            this.processAllBatches(dataEntryTask, importBatchRecords, importStatistics, metadataContext, errorWorkbook, workbookLock);
        }
        catch (Exception e) {
            try {
                log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25masterId:{}", (Object)masterId, (Object)e);
                CounterContext.markInitializationError((String)masterId);
            }
            catch (Throwable throwable) {
                this.finalizeProcessing(importStatistics, importBatchRecords, CounterContext.get((String)masterId), errorWorkbook);
                throw throwable;
            }
            this.finalizeProcessing(importStatistics, importBatchRecords, CounterContext.get((String)masterId), errorWorkbook);
        }
        this.finalizeProcessing(importStatistics, importBatchRecords, CounterContext.get((String)masterId), errorWorkbook);
    }

    private void processAllBatches(DataEntryTask dataEntryTask, List<ImportBatchRecord> importBatchRecords, ImportStatistics importStatistics, MetadataContext metadataContext, SXSSFWorkbook errorWorkbook, Object workbookLock) {
        AppAuthContext context = AppAuthContextHolder.getContext();
        Locale locale = LocaleContextHolder.getLocale();
        ConcurrentSubmitUtils task = ConcurrentSubmitUtils.build((ExecutorService)this.taskExecutor);
        importBatchRecords.forEach(importBatchRecord -> task.addCollections(() -> {
            AppAuthContextHolder.setContext((AppAuthContext)context);
            LocaleContextHolder.setLocale((Locale)locale);
            this.processBatchRecord(dataEntryTask, importBatchRecord.getBatchSeq().intValue(), importStatistics, metadataContext, errorWorkbook, workbookLock);
        }));
        task.getCollectionsWithTimeout(JaProperty.getLong((String)"athena.import.batch.async.timeout", (Long)1800L).longValue(), TimeUnit.SECONDS);
    }

    private MetadataContext initializeMetadataContext(DataEntryTask dataEntryTask, ImportStatistics importStatistics) {
        try {
            DWSecurityToken dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken((String)dataEntryTask.getUserToken());
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            AuthoredUser authoredUser = this.tokenVerifyService.getUserInfo(dwSecurityContext.getUserToken());
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            LocaleContextHolder.setLocale((Locale)JaI18nUtil.parseLocales((String)dataEntryTask.getLocale().replace('_', '-')));
            GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaDataBySecurityToken(importStatistics.getActionId(), dwSecurityContext.getUserToken(), dataEntryTask.getLocale(), dataEntryTask.getUserToken());
            ApiDataFieldLocaleMetadataDTO mainMetadata = this.metaDataService.getMainMetadata(metadataDTO, dataEntryTask.getActionInfo());
            List cellTypeContainers = this.metaDataService.getCellTypeContainers(mainMetadata.getField(), authoredUser.getToken(), null, dataEntryTask.getLocale(), 1);
            Map metaData = this.metaDataService.getHeaderMap(mainMetadata);
            Map cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainersBySecurityToken(metadataDTO, dwSecurityContext.getUserToken(), importStatistics.getUserToken(), dataEntryTask.getLocale());
            List businessKeyContainer = this.excelHelperV2.getBusinessKeyContainer(new ArrayList(cellTypeContainerMap.values()));
            List arrayKeyContainer = this.excelHelperV2.getArrayKeyContainer(new ArrayList(cellTypeContainerMap.values()));
            HashSet arrayField = CollectionUtils.isEmpty((Collection)arrayKeyContainer) ? new HashSet() : arrayKeyContainer.stream().map(CellTypeContainer::getKeyName).collect(Collectors.toSet());
            String productName = this.metaDataService.getProductNameBySecurityToken(dwSecurityContext.getUserToken(), dataEntryTask.getActionId().substring(dataEntryTask.getActionId().contains("esp_") ? 4 : 0), dataEntryTask.getUserToken());
            return new MetadataContext(metadataDTO, metaData, cellTypeContainerMap, businessKeyContainer, arrayField, cellTypeContainers, productName);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5143\u6570\u636e\u5931\u8d25:{}", (Object)dataEntryTask.getUserToken(), (Object)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0106.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.resolveTokenError", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatchRecord(DataEntryTask dataEntryTask, int batchNo, ImportStatistics importStatistics, MetadataContext metadataContext, SXSSFWorkbook existingWorkbook, Object workbookLock) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int batchSize = 0;
        String masterId = importStatistics.getMasterId();
        ArrayList errorList = null;
        try {
            errorList = new ArrayList();
            List data = this.getImportDataList(importStatistics.getMasterId(), Integer.valueOf(batchNo), dataEntryTask.getTableKey());
            batchSize = data.size();
            List validateErrorList = this.metaDataService.validateByBatchV2(dataEntryTask, metadataContext.getCellTypes(), data);
            if (CollectionUtils.isEmpty((Collection)validateErrorList)) {
                EspResponse response = this.sendByBatchWapper(dataEntryTask, metadataContext, data);
                if (response.isOK()) {
                    CounterContext.markSuccess((String)masterId, (int)batchSize);
                } else {
                    this.handleApiError(data, response, dataEntryTask, errorList, batchSize, batchNo);
                }
            } else {
                this.handleValidationError(masterId, errorList, batchSize, validateErrorList);
            }
        }
        catch (Exception e) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u5904\u7406\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
            CounterContext.markError((String)masterId, (int)batchSize);
        }
        finally {
            if (!CollectionUtils.isEmpty(errorList)) {
                Object object = workbookLock;
                synchronized (object) {
                    this.createErrorExcel(metadataContext, importStatistics, dataEntryTask, errorList, existingWorkbook);
                }
            }
        }
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u6279\u6b21 {} \u5904\u7406\u5b8c\u6210, \u8017\u65f6: {}ms", (Object)batchNo, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private EspResponse sendByBatchWapper(DataEntryTask dataEntryTask, MetadataContext metadataContext, List<Map> data) {
        if (!JaProperty.getBoolean((String)"athena.import.redis-queue.mock.enable", (Boolean)false).booleanValue()) {
            EspResponse response = this.espService.sendByBatch(dataEntryTask, metadataContext.getMetadataDTO(), data, metadataContext.getProductName());
            if (null == response) {
                response = new EspResponse();
                response.setData(null);
                response.setStatus(EspResponse.Status.FAILED);
            }
            return response;
        }
        try {
            Thread.sleep(JaProperty.getLong((String)"athena.export.redis-queue.mock.timeout", (Long)200L));
        }
        catch (InterruptedException e) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]InterruptedException error", (Throwable)e);
        }
        EspResponse response = new EspResponse();
        response.setData(null);
        response.setStatus(EspResponse.Status.SUCCESS);
        return response;
    }

    private void handleApiError(List<Map> data, EspResponse response, DataEntryTask dataEntryTask, List<Map<String, Object>> errorList, int batchSize, int batchNo) {
        List importErrorResult;
        log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u8c03\u7528esp\u670d\u52a1\u5931\u8d25\uff0c\u6279\u6b21 {}", (Object)batchNo);
        if (response.getData() == null) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u8c03\u7528esp\u670d\u52a1\u5931\u8d25\uff0cdata\u6570\u636e\u4e3a\u7a7a");
            importErrorResult = this.batchError(data);
        } else {
            importErrorResult = this.parseResponse(dataEntryTask.getTableKey(), response);
        }
        if (importErrorResult == null) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u8c03\u7528esp\u670d\u52a1\uff0c\u89e3\u6790\u5bfc\u5165\u5f02\u5e38\u6570\u636e\u5931\u8d25,\u89e3\u6790\u9519\u8bef\u4fe1\u606f\u4e3a\u7a7a!");
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0107.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.handleDataError", (Object[])new Object[0]));
        }
        CounterContext.markFailure((String)dataEntryTask.getMasterId(), (int)(batchSize - importErrorResult.size()), (int)importErrorResult.size());
        errorList.addAll(importErrorResult);
    }

    private void handleValidationError(String masterId, List<Map<String, Object>> errorList, int batchSize, List<Map> validateErrorList) {
        CounterContext.markFailure((String)masterId, (int)(batchSize - validateErrorList.size()), (int)validateErrorList.size());
        errorList.addAll(validateErrorList.stream().map(map -> map).collect(Collectors.toList()));
    }

    private void createErrorExcel(MetadataContext metadataContext, ImportStatistics importStatistics, DataEntryTask dataEntryTask, List<Map<String, Object>> errorList, SXSSFWorkbook existingWorkbook) {
        try {
            GetActionLocaleResponseDTO metadataDTO = metadataContext.getMetadataDTO();
            String mainKey = metadataDTO.getResponse().getData().getData_name();
            String mainKeyDescription = metadataDTO.getResponse().getData().getDescription();
            this.excelHelperV2.createDataExcel(ExcelHelper.getSheetName((String)mainKey, (String)mainKeyDescription, (Boolean)true), importStatistics.getLocale(), 2, dataEntryTask.getKeyList(), metadataContext.getCellTypeContainerMap(), metadataContext.getMetaData(), errorList, (Workbook)existingWorkbook, metadataContext.getBusinessKeyContainer(), 0, null, null, metadataContext.getArrayField());
        }
        catch (Exception e) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u751f\u6210\u9519\u8bef\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private void finalizeProcessing(ImportStatistics importStatistics, List<ImportBatchRecord> importBatchRecords, ImportCounters counters, SXSSFWorkbook errorWorkbook) {
        if (null == counters) {
            return;
        }
        counters.setFailUrl(this.handleErrorFile(importStatistics, errorWorkbook));
        this.importStatisticsDomainService.updateImportDb(importStatistics, importBatchRecords, counters);
    }

    private String handleErrorFile(ImportStatistics importStatistics, SXSSFWorkbook errorWorkbook) {
        if (errorWorkbook == null) {
            return null;
        }
        String failedUrl = null;
        try {
            if (!this.excelHelperV2.isWorkbookEmpty(errorWorkbook)) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(importStatistics.getMasterId());
                failedUrl = this.exportStatisticsDomainService.handleDownloadBaseDataV2(errorWorkbook, fileInfo);
            } else {
                errorWorkbook.dispose();
            }
        }
        catch (Exception e) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u4e0a\u4f20\u6587\u4ef6\u62a5\u9519", (Throwable)e);
        }
        return failedUrl;
    }

    private List<Map<String, Object>> batchError(List<Map> dataList) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        dataList.forEach(item -> {
            HashMap row = MapUtil.newHashMap((int)item.size());
            row.putAll(item);
            row.put("batch_error_msg", MessageUtil.getMessage((String)"delivery.batchHandleError", (Object[])new Object[0]));
            result.add(row);
        });
        return result;
    }

    public List<Map> getImportDataList(String masterId, Integer batchNo, String dataName) {
        ArrayList<Map> dataList = new ArrayList<Map>();
        List mainDataList = MongoCacheUtils.queryMainDataSourceBatch((String)masterId, (Integer)batchNo, (String)dataName);
        log.info("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u6279\u6b21[{}]\u4e3b\u6570\u636e\u91cf: {}", (Object)batchNo, (Object)mainDataList.size());
        if (!CollectionUtils.isEmpty((Collection)mainDataList)) {
            HashMap cache = MapUtil.newHashMap((int)mainDataList.size());
            this.preloadDataToCache(mainDataList, (Map)cache);
            mainDataList.forEach(mainData -> {
                dataList.add(mainData.getData());
                this.processChildIteratively(mainData, cache);
            });
        }
        return dataList;
    }

    private void processChildIteratively(ExeclCacheLog root, Map<String, List<ExeclCacheLog>> cache) {
        ArrayDeque<ExeclCacheLog> stack = new ArrayDeque<ExeclCacheLog>();
        stack.push(root);
        while (!stack.isEmpty()) {
            ExeclCacheLog current = (ExeclCacheLog)stack.pop();
            String currentKey = this.buildKey(current.getBk(), current.getMasterId(), current.getNextDb());
            List<ExeclCacheLog> children = cache.getOrDefault(currentKey, Collections.emptyList());
            if (CollectionUtils.isEmpty(children)) continue;
            current.getData().put(current.getNextDb(), children.stream().map(ExeclCacheLog::getData).collect(Collectors.toList()));
            children.forEach(stack::push);
        }
    }

    private void preloadDataToCache(List<ExeclCacheLog> mainDataList, Map<String, List<ExeclCacheLog>> cache) {
        List result = mainDataList.stream().filter(t -> !Objects.equals(t.getNextDb(), "-1")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        List indexs = result.stream().filter(log -> log.getBk() != null && !log.getBk().isEmpty()).map(ExeclCacheLog::getBk).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(indexs)) {
            return;
        }
        List childs = MongoCacheUtils.queryByPbksBatch(indexs, (String)((ExeclCacheLog)result.get(0)).getMasterId(), (String)((ExeclCacheLog)result.get(0)).getNextDb());
        for (ExeclCacheLog child : childs) {
            String db;
            String masterId;
            List pBk = child.getPBk();
            String key = this.buildKey(pBk, masterId = child.getMasterId(), db = child.getDb());
            if (StringUtils.isEmpty((String)key)) continue;
            cache.compute(key, (k, oldValue) -> {
                if (Objects.isNull(oldValue)) {
                    oldValue = new ArrayList<ExeclCacheLog>();
                }
                oldValue.add(child);
                return oldValue;
            });
        }
        this.preloadDataToCache(childs, cache);
    }

    private String buildKey(List<IndexOption> pBk, String masterId, String db) {
        if (StringUtils.isEmpty((String)masterId) || StringUtils.isEmpty((String)db) || CollectionUtils.isEmpty(pBk)) {
            return null;
        }
        return pBk.stream().map(item -> String.valueOf(item.getIndex())).sorted().collect(Collectors.joining("|", masterId + ":" + db + ":", ""));
    }

    private ImportCounters createCounters(ImportStatistics stats) {
        return new ImportCounters(stats.getProcessingNum().intValue(), stats.getFailedNum().intValue(), stats.getErrorNum().intValue(), stats.getSucceededNum().intValue());
    }

    public List<Map<String, Object>> parseResponse(String tableKey, EspResponse response) {
        EspBody espBody = (EspBody)response.getData();
        if (null == espBody) {
            log.error("[\u57fa\u7840\u8d44\u6599\u5bfc\u5165]\u8c03\u7528esp\u670d\u52a1\u5931\u8d25\uff0cespBody.data\u6570\u636e\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        return (List)espBody.getStd_data().getParameter().get(tableKey);
    }
}

