/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEventFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventPublisher;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsDomainService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainCountInfoTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import com.digiwin.athena.abt.core.ie.strategy.AbstractIETaskStrategy;
import com.digiwin.athena.abt.core.meta.dto.ImportCounters;
import com.digiwin.athena.abt.core.uiils.CounterContext;
import com.digiwin.athena.abt.presentation.mq.ImportBasicDataRedisListener;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.core.context.ASKContext;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImportBasicDataTaskStrategy
extends AbstractIETaskStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportBasicDataTaskStrategy.class);
    @Autowired
    private ImportBasicDataRedisListener importBasicDataRedisListener;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private ImportStatisticsDomainService importStatisticsDomainService;

    public boolean supports(String businessType) {
        return IEExportBusinessTypeEnum.BASIC_IMPORT.getType().equalsIgnoreCase(businessType);
    }

    public void doExecute(IERedisSubTask ieRedisTask) {
        DataEntryTask task = this.castToDataEntryTask(ieRedisTask);
        log.info("------------>execute\u6267\u884c\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u4efb\u52a1:" + JsonUtils.objectToString((Object)ieRedisTask));
        ImportBasicDataTaskStrategy.clearContext((DataEntryTask)task);
        this.importBasicDataRedisListener.consumerBatch(task);
    }

    public void doSuccess(IERedisSubTask ieRedisTask) {
        DataEntryTask task = this.castToDataEntryTask(ieRedisTask);
        try {
            this.publishCompletionEvent(task);
        }
        finally {
            ImportBasicDataTaskStrategy.clearContext((DataEntryTask)task);
        }
        log.info("=============>doSuccess,masterId:{}", (Object)task.getMasterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFail(IERedisSubTask ieRedisTask, Throwable throwable) {
        DataEntryTask task = this.castToDataEntryTask(ieRedisTask);
        try {
            this.updateTaskStatus(task);
            this.publishCompletionEvent(task);
        }
        finally {
            ImportBasicDataTaskStrategy.clearContext((DataEntryTask)task);
        }
        log.error("=============>doFail,masterId:{}", (Object)task.getMasterId(), (Object)throwable);
    }

    public void doTimeout(IERedisSubTask ieRedisTask) {
        DataEntryTask task = this.castToDataEntryTask(ieRedisTask);
        try {
            this.updateTaskStatus(task);
            this.publishCompletionEvent(task);
        }
        finally {
            ImportBasicDataTaskStrategy.clearContext((DataEntryTask)task);
        }
        log.info("=============>doTimeout,masterId:{}", (Object)task.getMasterId());
    }

    public void doAllComplete(IERedisMainCountInfoTask mainCoutInfoTask) {
        List list = mainCoutInfoTask.getInfo().getSubTaskIdList();
        log.info("=============>doAllComplete,masterId:{}", (Object)(CollectionUtils.isEmpty((Collection)list) ? "" : String.join((CharSequence)", ", list)));
    }

    private static void clearContext(DataEntryTask dataEntryTask) {
        AppAuthContextHolder.clearContext();
        ASKContext.getInstance().remove();
        LocaleContextHolder.resetLocaleContext();
        CounterContext.clear((String)dataEntryTask.getMasterId());
    }

    private DataEntryTask castToDataEntryTask(IERedisSubTask ieRedisTask) {
        if (!(ieRedisTask instanceof DataEntryTask)) {
            String errorMsg = "\u4efb\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u671f\u671b\u7c7b\u578b: DataEntryTask, \u5b9e\u9645\u7c7b\u578b: " + ieRedisTask.getClass().getName();
            log.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        return (DataEntryTask)ieRedisTask;
    }

    private void updateTaskStatus(DataEntryTask task) {
        ImportStatistics importStatistics = this.importStatisticsDomainService.queryImportStatisticsByMasterId(task.getMasterId());
        List importBatchRecords = this.importStatisticsDomainService.queryImportBatchRecordsByMasterId(task.getMasterId());
        ImportCounters counters = CounterContext.get((String)task.getMasterId());
        if (counters != null) {
            counters.markInitializationError();
            this.importStatisticsDomainService.updateImportDb(importStatistics, importBatchRecords, counters);
        }
    }

    private void publishCompletionEvent(DataEntryTask task) {
        ImportStatistics importStatistics = this.importStatisticsDomainService.queryImportStatisticsByMasterId(task.getMasterId());
        if (importStatistics != null && importStatistics.getProcessingNum() == 0) {
            ImportSuccessEvent event = ImportSuccessEventFactory.produceByImportStatistics((ImportStatistics)importStatistics);
            this.eventPublisher.publish(event);
        }
    }
}

