/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ActivityStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DapResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadTemplateParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ErrorTableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ExportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetActivityStatisticsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetErrorTableParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetExportingNumParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetProcessingNumParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ImportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.QueryExportStatisticsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.QueryImportStatisticsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UserStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.excel.ExcelParserBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.service.abt.migration.assembler.ImportStatisticsAssembler;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryRedisService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportHistoryDataRedisService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsFactory;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/abt/v1/baseDataEntry"})
public class BaseDataEntryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDataEntryInterface.class);
    @Autowired
    BaseDataEntryApplicationServiceImpl baseDataEntryService;
    @Autowired
    ExportStatisticsFactory exportStatisticsFactory;
    @Autowired
    private ExportHistoryDataRedisService exportHistoryDataRedisService;
    @Autowired
    private BaseDataEntryRedisService baseDataEntryRedisService;

    @PostMapping(value={"upload"})
    @ResponseBody
    public DapResponse upload(@RequestPart(value="uploadParam") UploadParamDTO uploadParam, @RequestPart(value="file") MultipartFile file) {
        if (null == file || file.isEmpty() || StringUtils.isEmpty((String)file.getOriginalFilename())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.fileEmpty", (Object[])new Object[0]));
        }
        String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!StringUtils.equalsIgnoreCase((String)extension, (String)"xls") && !StringUtils.equalsIgnoreCase((String)extension, (String)"xlsx")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0079.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.fileFormatEmpty", (Object[])new Object[0]));
        }
        ExcelParserBean parserBean = new ExcelParserBean();
        try {
            parserBean.setInput(file.getInputStream());
        }
        catch (Exception e) {
            log.error("upload exception", (Throwable)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0080.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.uploadError2", (Object[])new Object[0]));
        }
        parserBean.setFilePath(file.getOriginalFilename());
        this.baseDataEntryService.upload(uploadParam, parserBean);
        log.info("upload success");
        return DapResponse.ok((Object)MessageUtil.getMessage((String)"delivery.success", (Object[])new Object[0]));
    }

    @PostMapping(value={"uploadAsync"})
    @ResponseBody
    public DapResponse uploadAsync(@RequestBody List<UploadParamDTO> uploadParam) {
        this.baseDataEntryService.uploadAsync(uploadParam);
        log.info("upload success");
        return DapResponse.ok((Object)MessageUtil.getMessage((String)"delivery.success", (Object[])new Object[0]));
    }

    @PostMapping(value={"republish"})
    public DapResponse republish(@RequestBody UploadParamDTO uploadParamDTO) {
        this.baseDataEntryService.republish(uploadParamDTO);
        return DapResponse.ok();
    }

    @PostMapping(value={"republishById"})
    public DapResponse republishById(@RequestBody UploadParamDTO uploadParamDTO) {
        this.baseDataEntryService.republishById(uploadParamDTO);
        return DapResponse.ok();
    }

    @PostMapping(value={"downloadTemplate"})
    public DapResponse downloadTemplate(@RequestBody DownloadTemplateParamDTO param) {
        byte[] fileBytes = this.baseDataEntryService.downloadTemplate(param);
        return DapResponse.ok((Object)fileBytes);
    }

    @GetMapping(value={"getTableHeaders"})
    public DapResponse getTableHeaders(@RequestParam(value="actionId") String actionId) {
        return DapResponse.ok((Object)this.baseDataEntryService.getTableHeaders(actionId));
    }

    @PostMapping(value={"getErrorTable"})
    public DapResponse getErrorTable(@RequestBody GetErrorTableParamDTO param) {
        ErrorTable errorTable = this.baseDataEntryService.getErrorTableByMasterId(param.getMasterId(), param.getLocale());
        ErrorTableDTO errorTableDTO = ImportStatisticsAssembler.errorTableToDTO((ErrorTable)errorTable);
        return DapResponse.ok((Object)errorTableDTO);
    }

    @PostMapping(value={"getActivityStatistics"})
    public DapResponse getActivityStatistics(@RequestBody GetActivityStatisticsParamDTO param) {
        ActivityStatistics activityStatistics = this.baseDataEntryService.getActivityStatistics(param.getActivityCode(), param.getUserId());
        ActivityStatisticsDTO activityStatisticsDTO = ImportStatisticsAssembler.activityStatisticsToDTO((ActivityStatistics)activityStatistics);
        return DapResponse.ok((Object)activityStatisticsDTO);
    }

    @PostMapping(value={"getImportStatistics"})
    public DapResponse getImportStatistics(@RequestBody QueryImportStatisticsParamDTO param) {
        ImportStatistics importStatistics = this.baseDataEntryService.getImportStatistics(param.getMasterId());
        ImportStatisticsDTO importStatisticsDTO = ImportStatisticsAssembler.toDTO((ImportStatistics)importStatistics);
        return DapResponse.ok((Object)importStatisticsDTO);
    }

    @PostMapping(value={"getProcessingNum"})
    public DapResponse getProcessingNum(@RequestBody GetProcessingNumParamDTO param) {
        String userId = param.getUserId();
        UserStatistics userStatistics = this.baseDataEntryService.getProcessingNum(userId, param.getTenantId());
        UserStatisticsDTO userStatisticsDTO = new UserStatisticsDTO();
        userStatisticsDTO.setUserId(userId);
        userStatisticsDTO.setProcessingNum(userStatistics.getProcessingNum());
        return DapResponse.ok((Object)userStatisticsDTO);
    }

    @PostMapping(value={"getRecords"})
    public DapResponse getRecords(@RequestBody GetRecordsParamDTO param) {
        List importStatisticsList = this.baseDataEntryService.getRecordsByUserId(param.getUser(), param.getLocale(), param.getGetRecordsNum(), param.getActivityName(), param.getStartTime(), param.getEndTime(), param.getType(), param.getState(), param.getOffset());
        List importStatisticsDTOList = ImportStatisticsAssembler.importStatisticsListToDTO((List)importStatisticsList);
        return DapResponse.ok((Object)importStatisticsDTOList);
    }

    @GetMapping(value={"/import/basicDataList"})
    public DapResponse getBasicDataList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List basicDataList = this.baseDataEntryService.getBasicDataList(user);
        return DapResponse.ok((Object)basicDataList);
    }

    @GetMapping(value={"/export/basicDataList"})
    public DapResponse exportBasicDataList() {
        List exportBasicDataList = this.baseDataEntryService.getExportBasicDataList();
        return DapResponse.ok((Object)exportBasicDataList);
    }

    @PostMapping(value={"downloadBaseData"})
    public DapResponse downloadBaseData(@RequestBody DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        byte[] fileBytes = this.baseDataEntryService.downloadBaseData(downloadBaseDataParamDTO);
        return DapResponse.ok((Object)fileBytes);
    }

    @PostMapping(value={"startDownload"})
    public DapResponse startDownload(@RequestBody DownloadBaseDataParamDTO param) {
        String type = Optional.ofNullable(param.getType()).orElse("default");
        if (RedisQueueContant.EXPORT_DETAIL_TYPE.contains(type)) {
            return DapResponse.ok((Object)this.baseDataEntryService.startDownload(param));
        }
        return DapResponse.ok((Object)(JaProperty.getBoolean((String)"athena.export.redis-queue.enable", (Boolean)Boolean.TRUE) != false ? this.baseDataEntryRedisService.startDownload(param) : this.baseDataEntryService.startDownload(param)));
    }

    @PostMapping(value={"historyStartDownload"})
    public DapResponse historyStartDownload(@RequestBody Map<String, Object> paramMap) {
        if (JaProperty.getBoolean((String)"athena.export.redis-queue.enable", (Boolean)Boolean.TRUE).booleanValue()) {
            return DapResponse.ok((Object)this.exportHistoryDataRedisService.historyStartDownload(paramMap));
        }
        return DapResponse.ok((Object)this.baseDataEntryService.historyStartDownload(paramMap));
    }

    @PostMapping(value={"queryExportStatistics"})
    public DapResponse queryExportStatistics(@RequestBody QueryExportStatisticsParamDTO param) {
        ExportStatisticsDTO exportStatisticsDTO = this.baseDataEntryService.queryExportStatistics(param.getMasterId());
        return DapResponse.ok((Object)exportStatisticsDTO);
    }

    @PostMapping(value={"queryExportRecords"})
    public DapResponse queryExportRecords(@RequestBody GetRecordsParamDTO param) {
        List exportStatisticsList = this.baseDataEntryService.getExportRecordsByUserId(param.getUser(), param.getLocale(), param);
        List importStatisticsDTOList = ExportStatisticsFactory.exportStatisticsListToDTO((List)exportStatisticsList);
        return DapResponse.ok((Object)importStatisticsDTOList);
    }

    @PostMapping(value={"getExportingNum"})
    public DapResponse getExportingNum(@RequestBody GetExportingNumParamDTO param) {
        String userId = param.getUserId();
        UserStatistics userStatistics = this.baseDataEntryService.getExportingNum(userId, param.getTenantId(), param.getType(), param.getTypes());
        UserStatisticsDTO userStatisticsDTO = new UserStatisticsDTO();
        userStatisticsDTO.setUserId(userId);
        userStatisticsDTO.setProcessingNum(userStatistics.getProcessingNum());
        return DapResponse.ok((Object)userStatisticsDTO);
    }

    @PostMapping(value={"updateRetryDownloadState"})
    public DapResponse updateRetryDownloadState(@RequestParam(value="masterId") String masterId) {
        this.baseDataEntryService.updateRetryDownloadState(masterId);
        return DapResponse.ok();
    }
}

