/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEGrayModeEnum;
import com.digiwin.athena.abt.core.ie.dto.ExportTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/abt/v1/ieenv"})
public class IEEnvController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IEEnvController.class);
    @Autowired
    private ConfigurableEnvironment environment;
    private static final String IE_ENV_GRAY = "ie_env_gray";
    @Autowired
    private IEService exportService;

    @GetMapping(value={"/test"})
    public ResponseEntity test() {
        String tenantId = "123";
        String mainTaskId = UUID.randomUUID().toString();
        String taskType = IEExportTaskTypeEnum.EXPORT.getType();
        String businessType = IEExportBusinessTypeEnum.HISTORY.getType();
        IERedisMainTask mainTask = new IERedisMainTask();
        mainTask.setMainTaskId(mainTaskId);
        mainTask.setTaskType(taskType);
        mainTask.setReceiveTime(new Date());
        IERedisSubTask ieRedisTask = new IERedisSubTask();
        ieRedisTask.setSubTaskId(UUID.randomUUID().toString());
        ieRedisTask.setTenantId(tenantId);
        ieRedisTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
        ieRedisTask.setMainTaskId(mainTaskId);
        ieRedisTask.setBusinessType(businessType);
        ieRedisTask.setReceiveTime(new Date());
        ieRedisTask.setTaskClazz(ExportTask.class.getName());
        IERedisSubTask ieRedisTask2 = new IERedisSubTask();
        ieRedisTask2.setSubTaskId(UUID.randomUUID().toString());
        ieRedisTask2.setTenantId(tenantId);
        ieRedisTask2.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
        ieRedisTask2.setMainTaskId(mainTaskId);
        ieRedisTask2.setBusinessType(businessType);
        ieRedisTask2.setReceiveTime(new Date());
        ieRedisTask2.setTaskClazz(ExportTask.class.getName());
        mainTask.setSubTaskList((List)Lists.newArrayList((Object[])new IERedisSubTask[]{ieRedisTask, ieRedisTask2}));
        this.exportService.submit(mainTask);
        return ResponseEntity.ok((Object)"ok");
    }

    @PostMapping(value={"/setEnv"})
    public ResponseEntity setGrayEnv(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (!"127.0.0.1".equals(remoteAddr) && !"0:0:0:0:0:0:0:1".equals(remoteAddr)) {
            return ResponseEntity.status((int)403).body((Object)"\u7981\u6b62\u8bbf\u95ee: \u4ec5\u5141\u8bb8\u672c\u5730\u8c03\u7528");
        }
        this.environment.getPropertySources().stream().filter(source -> source instanceof MapPropertySource).findFirst().ifPresent(source -> ((Map)((MapPropertySource)source).getSource()).put(IE_ENV_GRAY, IEGrayModeEnum.INCLUDE.getType()));
        String value = this.environment.getProperty(IE_ENV_GRAY);
        log.info("ie_env_gray value:{}", (Object)value);
        return ResponseEntity.ok((Object)("\u8bbe\u7f6e\u6210\u529f,ie_env_gray=" + value));
    }

    @PostMapping(value={"/delEnv"})
    public ResponseEntity delGrayEnv(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (!"127.0.0.1".equals(remoteAddr) && !"0:0:0:0:0:0:0:1".equals(remoteAddr)) {
            return ResponseEntity.status((int)403).body((Object)"\u7981\u6b62\u8bbf\u95ee: \u4ec5\u5141\u8bb8\u672c\u5730\u8c03\u7528");
        }
        this.environment.getPropertySources().stream().filter(source -> source instanceof MapPropertySource).findFirst().ifPresent(source -> ((Map)((MapPropertySource)source).getSource()).remove(IE_ENV_GRAY));
        String value = this.environment.getProperty(IE_ENV_GRAY);
        log.info("ie_env_gray value:{}", (Object)value);
        return ResponseEntity.ok((Object)("\u6e05\u9664\u6210\u529f,ie_env_gray=" + value));
    }
}

