/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DapResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.dto.request.UploadBatchFileReq;
import com.digiwin.athena.abt.application.dto.request.UploadBatchReq;
import com.digiwin.athena.abt.application.service.abt.migration.inout.BaseDataEntryRedisService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ErrorHandlerService;
import com.digiwin.athena.abt.application.utils.JsonToMd5Converter;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/abt/v2/baseDataEntry"})
public class ImportBasicDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportBasicDataController.class);
    @Autowired
    private BaseDataEntryRedisService baseDataEntryRedisService;
    @Autowired
    private ErrorHandlerService errorHandlerService;
    @Autowired
    private DMCConfig dmcConfig;

    @PostMapping(value={"/uploadBatch"})
    @ResponseBody
    public DapResponse uploadBatch(@RequestBody UploadBatchReq uploadBatchReq) {
        if (CollectionUtils.isEmpty((Collection)uploadBatchReq.getFiles())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0078.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.fileEmpty", (Object[])new Object[0]));
        }
        Map fileUidMap = JsonToMd5Converter.getFileUids((UploadBatchReq)uploadBatchReq);
        this.baseDataEntryRedisService.checkUploadParams(uploadBatchReq, fileUidMap);
        this.baseDataEntryRedisService.uploadBatch(uploadBatchReq, fileUidMap);
        return DapResponse.ok((Object)MessageUtil.getMessage((String)"delivery.success", (Object[])new Object[0]));
    }

    @PostMapping(value={"/uploadBatch/test"})
    @ResponseBody
    public DapResponse uploadBatchTest(@RequestParam String actionId, @RequestParam String activityId, @RequestParam Integer isReImport, MultipartFile[] files, @RequestParam(required=false) String actionInfo, @RequestParam(required=false) Set<String> requiredFields) {
        UploadBatchReq uploadBatchReq = new UploadBatchReq();
        uploadBatchReq.setIsReImport(isReImport);
        uploadBatchReq.setActionId(actionId);
        uploadBatchReq.setActivityId(activityId);
        uploadBatchReq.setActionInfo(actionInfo);
        uploadBatchReq.setRequiredFields(requiredFields);
        ArrayList<UploadBatchFileReq> list = new ArrayList<UploadBatchFileReq>();
        for (int i = 0; i < files.length; ++i) {
            MultipartFile file = files[i];
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName(file.getOriginalFilename());
            fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
            String url = this.errorHandlerService.upload(file, fileInfo);
            UploadBatchFileReq uploadBatchFileReq = new UploadBatchFileReq();
            uploadBatchFileReq.setFileUrl(url);
            uploadBatchFileReq.setFileName(file.getOriginalFilename());
            uploadBatchFileReq.setCheckSum(JaUUID.UUID19());
            list.add(uploadBatchFileReq);
        }
        uploadBatchReq.setFiles(list);
        this.uploadBatch(uploadBatchReq);
        return DapResponse.ok((Object)uploadBatchReq);
    }

    @PostMapping(value={"/uploadFile/test"})
    @ResponseBody
    public DapResponse uploadFileTest(MultipartFile[] files) {
        UploadBatchReq uploadBatchReq = new UploadBatchReq();
        ArrayList<UploadBatchFileReq> list = new ArrayList<UploadBatchFileReq>();
        for (int i = 0; i < files.length; ++i) {
            MultipartFile file = files[i];
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName(file.getOriginalFilename());
            fileInfo.setDirectoryId(this.dmcConfig.getErrorTableUUID());
            String url = this.errorHandlerService.upload(file, fileInfo);
            UploadBatchFileReq uploadBatchFileReq = new UploadBatchFileReq();
            uploadBatchFileReq.setFileUrl(url);
            uploadBatchFileReq.setFileName(file.getOriginalFilename());
            uploadBatchFileReq.setCheckSum(JaUUID.UUID19());
            list.add(uploadBatchFileReq);
        }
        uploadBatchReq.setFiles(list);
        return DapResponse.ok((Object)uploadBatchReq);
    }
}

