/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.OpenBaseDataEntryApplicationServiceImpl;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.ActionInfoDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ActivityStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadExportFileParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateReqDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ErrorTableDTO;
import com.digiwin.athena.atdm.importstatistics.dto.GetRecordsParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ImportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UploadParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UserStatisticsDTO;
import com.digiwin.athena.atdm.util.MessageUtil;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"baseDataEntry"})
public class OpenDataEntryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenDataEntryInterface.class);
    @Autowired
    OpenBaseDataEntryApplicationServiceImpl baseDataEntryService;
    private final String LOCALE = "locale";

    @PostMapping(value={"upload"})
    @ResponseBody
    public DapResponse upload(@RequestParam String actionId, @RequestParam String activityId, MultipartFile file) {
        UploadParamDTO uploadParam = new UploadParamDTO();
        uploadParam.setActionId(actionId);
        uploadParam.setActivityId(activityId);
        return this.baseDataEntryService.dealUpload(uploadParam, file);
    }

    @PostMapping(value={"uploadBatch"})
    @ResponseBody
    public DapResponse uploadBatch(@RequestParam String actionId, @RequestParam String activityId, MultipartFile[] files, @RequestParam(required=false) String actionInfo, @RequestParam(required=false) Set<String> requiredFields) {
        UploadParamDTO uploadParam = new UploadParamDTO();
        uploadParam.setActionId(actionId);
        uploadParam.setActivityId(activityId);
        if (CollectionUtils.isNotEmpty(requiredFields)) {
            LogDto logDto = new LogDto("\u5355\u5934\u5fc5\u586b\u9879\u5165\u53c2:", JsonUtils.objectToString(requiredFields));
            log.info(logDto.toString());
            uploadParam.setRequiredFields(requiredFields);
        }
        if (StringUtils.isNotBlank((String)actionInfo)) {
            uploadParam.setActionInfo((ActionInfoDTO)JsonUtils.jsonToObject((String)actionInfo, ActionInfoDTO.class));
        }
        for (MultipartFile file : files) {
            DapResponse response = this.baseDataEntryService.dealUpload(uploadParam, file);
            if (response.getStatus().equals(HttpStatus.OK.value())) continue;
            return response;
        }
        return DapResponse.ok((Object)MessageUtil.getMessage((String)"delivery.success", (Object[])new Object[0]));
    }

    @PostMapping(value={"uploadAsync"})
    @ResponseBody
    public DapResponse uploadAsync(@RequestBody List<UploadParamDTO> paramDTOS) {
        this.baseDataEntryService.uploadAsync(paramDTOS);
        return DapResponse.ok();
    }

    @PostMapping(value={"republish"})
    public DapResponse republish(@RequestBody UploadParamDTO uploadParamDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String userId = String.valueOf(user.getSid());
        uploadParamDTO.setUserId(userId);
        this.baseDataEntryService.republish(uploadParamDTO);
        return DapResponse.ok();
    }

    @PostMapping(value={"downloadErrorTable/{masterId:.+}"})
    public void downloadErrorTable(@PathVariable String masterId, @RequestBody DownloadTemplateDTO downloadTemplateDTO, HttpServletRequest request, HttpServletResponse response) {
        String locale = request.getHeader("locale");
        this.baseDataEntryService.downloadErrorTable(masterId, locale, downloadTemplateDTO.getRequiredFields(), response);
    }

    @GetMapping(value={"downloadErrorTable/{masterId}"})
    public void downloadErrorTable(@PathVariable String masterId, HttpServletRequest request, HttpServletResponse response) {
        String locale = request.getHeader("locale");
        this.baseDataEntryService.downloadErrorTable(masterId, locale, response);
    }

    @PostMapping(value={"downloadTemplate/{actionId:.+}"})
    public void downloadTemplate(@PathVariable String actionId, @RequestBody DownloadTemplateDTO downloadTemplateDTO, HttpServletRequest request, HttpServletResponse response) {
        String fileName = downloadTemplateDTO.getFileName();
        String locale = request.getHeader("locale");
        this.baseDataEntryService.downloadTemplate(actionId, locale, fileName, downloadTemplateDTO, response);
    }

    @PostMapping(value={"downloadTemplateBatch"})
    public void downloadTemplate(@RequestBody List<DownloadTemplateReqDTO> params, HttpServletRequest request, HttpServletResponse response) {
        this.baseDataEntryService.downloadTemplateBatch(params, response, request.getHeader("locale"));
    }

    @GetMapping(value={"downloadTemplate/{actionId:.+}"})
    public void downloadTemplate(@PathVariable String actionId, HttpServletRequest request, HttpServletResponse response) {
        String locale = request.getHeader("locale");
        this.baseDataEntryService.downloadTemplate(actionId, locale, "", response);
    }

    @Deprecated
    @PostMapping(value={"downloadBaseData/{actionId:.+}"})
    public void downloadBaseData(@PathVariable String actionId, @RequestBody DownloadBaseDataDTO downloadBaseDataDTO, HttpServletRequest request, HttpServletResponse response) {
        String loc = request.getHeader("locale");
        String locale = StringUtils.isEmpty((String)loc) ? "zh_CN" : loc;
        this.baseDataEntryService.downloadBaseData(actionId, downloadBaseDataDTO, locale, response);
    }

    @GetMapping(value={"getErrorTable/{masterId}"})
    public DapResponse getErrorTable(@PathVariable String masterId, HttpServletRequest request) {
        String locale = request.getHeader("locale");
        try {
            ErrorTableDTO errorTableDTO = this.baseDataEntryService.getErrorTableByMasterId(masterId, locale);
            return DapResponse.ok((Object)errorTableDTO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return DapResponse.failed((String)MessageUtil.getMessage((String)"basedata.nofile", (Object[])new Object[0]));
        }
    }

    @GetMapping(value={"getActivityStatistics/{activityCode}"})
    public DapResponse getActivityStatistics(@PathVariable String activityCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String userId = String.valueOf(user.getSid());
        ActivityStatisticsDTO activityStatisticsDTO = this.baseDataEntryService.getActivityStatistics(activityCode, userId);
        return DapResponse.ok((Object)activityStatisticsDTO);
    }

    @GetMapping(value={"getImportStatistics/{masterId}"})
    public DapResponse getImportStatistics(@PathVariable String masterId) {
        ImportStatisticsDTO importStatisticsDTO = this.baseDataEntryService.getImportStatistics(masterId);
        return DapResponse.ok((Object)importStatisticsDTO);
    }

    @GetMapping(value={"getProcessingNum"})
    public DapResponse getProcessingNum(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String userId = String.valueOf(user.getSid());
        UserStatisticsDTO userStatisticsDTO = this.baseDataEntryService.getProcessingNum(userId, user.getTenantId());
        return DapResponse.ok((Object)userStatisticsDTO);
    }

    @GetMapping(value={"getRecords"})
    @Deprecated
    public DapResponse getRecords(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, HttpServletRequest request) {
        String locale = request.getHeader("locale");
        List importStatisticsDTOList = this.baseDataEntryService.getRecordsByUserId(user, locale, null);
        return DapResponse.ok((Object)importStatisticsDTOList);
    }

    @PostMapping(value={"getRecords"})
    public DapResponse getRecords(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, HttpServletRequest request, @RequestBody GetRecordsParamDTO getRecordsParamDTO) {
        String locale = request.getHeader("locale");
        List importStatisticsDTOList = this.baseDataEntryService.getRecordsByUserId(user, locale, getRecordsParamDTO);
        return DapResponse.ok((Object)importStatisticsDTOList);
    }

    @PostMapping(value={"downloadBaseData", "open/downloadBaseData"})
    public void downloadBaseData(@RequestBody DownloadBaseDataParamDTO downloadBaseDataParamDTO, HttpServletRequest request, HttpServletResponse response) {
        this.baseDataEntryService.downloadBaseData(downloadBaseDataParamDTO, response);
    }

    @PostMapping(value={"startDownload"})
    public DapResponse startDownload(@RequestBody DownloadBaseDataParamDTO downloadBaseDataParamDTO, HttpServletRequest request, HttpServletResponse response) {
        if (Boolean.TRUE.equals(this.baseDataEntryService.startDownload(downloadBaseDataParamDTO))) {
            return DapResponse.ok();
        }
        return DapResponse.failed((String)MessageUtil.getMessage((String)"delivery.exportDataError", (Object[])new Object[0]));
    }

    @PostMapping(value={"startDownloadBatch"})
    public DapResponse startDownloadBatch(@RequestBody List<DownloadBaseDataParamDTO> downloadBaseDataParamDTO) {
        this.baseDataEntryService.startDownloadBatch(downloadBaseDataParamDTO);
        return DapResponse.ok();
    }

    @GetMapping(value={"getTableHeaders"})
    public DapResponse getTableHeaders(String actionId) {
        return DapResponse.ok((Object)this.baseDataEntryService.getTableHeader(actionId));
    }

    @GetMapping(value={"/import/basicDataList"})
    public DapResponse getImportBasicDataList() {
        List importAndExportConfig = this.baseDataEntryService.getImportAndExportConfig();
        return DapResponse.ok((Object)importAndExportConfig);
    }

    @GetMapping(value={"/export/basicDataList"})
    public DapResponse getExportBasicDataList() {
        List exportBasicDataList = this.baseDataEntryService.getExportBasicDataList();
        return DapResponse.ok((Object)exportBasicDataList);
    }

    @PostMapping(value={"downloadExportFile"})
    public void downloadExportFile(@RequestBody DownloadExportFileParamDTO downloadExportFileParamDTO, HttpServletRequest request, HttpServletResponse response) {
        this.baseDataEntryService.downloadExportFile(downloadExportFileParamDTO, response);
    }

    @PostMapping(value={"queryExportRecords"})
    public DapResponse queryExportRecords(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, HttpServletRequest request, @RequestBody GetRecordsParamDTO getRecordsParamDTO) {
        String locale = request.getHeader("locale");
        List exportStatisticsDTOList = this.baseDataEntryService.getExportRecordsByUserId(user, locale, getRecordsParamDTO);
        return DapResponse.ok((Object)exportStatisticsDTOList);
    }

    @GetMapping(value={"getExportingNum"})
    public DapResponse getExportingNum(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, String type, @RequestParam(required=false, value="types") List<String> types) {
        String userId = String.valueOf(user.getSid());
        UserStatisticsDTO userStatisticsDTO = this.baseDataEntryService.getExportingNum(userId, user.getTenantId(), type, types);
        return DapResponse.ok((Object)userStatisticsDTO);
    }

    @GetMapping(value={"retryDownload/{masterId}"})
    public DapResponse retryDownload(@PathVariable(value="masterId") String masterId) {
        DownloadExportFileParamDTO downloadExportFileParamDTO = new DownloadExportFileParamDTO();
        downloadExportFileParamDTO.setMasterId(masterId);
        this.baseDataEntryService.retryDownload(downloadExportFileParamDTO);
        return DapResponse.ok();
    }
}

