/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/abt/v1/job"})
@RestController
public class QuartzJobController {
    @Autowired
    private JobManager jobManager;

    @GetMapping(value={"/triggerJob/{jobName}/{jobGroup}"})
    public ResponseEntity<?> triggerJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        this.jobManager.runOnce(jobName, jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/pauseScheduleJob/{jobName}/{jobGroup}"})
    public ResponseEntity<?> pauseScheduleJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        this.jobManager.pauseScheduleJob(jobName, jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/resumeScheduleJob/{jobName}/{jobGroup}"})
    public ResponseEntity<?> resumeScheduleJob(@PathVariable String jobName, @PathVariable String jobGroup) {
        this.jobManager.resumeScheduleJob(jobName, jobGroup);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/getDetailJobData/{jobName}/{jobGroup}"})
    public ResponseEntity<?> getDetailJobData(@PathVariable String jobName, @PathVariable String jobGroup) {
        return ResponseEntityWrapper.wrapperOk((Object)this.jobManager.getDetailJobData(jobName, jobGroup));
    }

    @DeleteMapping(value={"/delJob/{jobName}/{group}"})
    public ResponseEntity<?> delJob(@PathVariable String jobName, @PathVariable String group) {
        this.jobManager.deleteJob(jobName, group);
        return ResponseEntityWrapper.wrapperOk();
    }
}

