/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.presentation.server.web;

import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardDto;
import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardMessageCompensateDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJob;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardInfosDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.UpdateTaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageConverter;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/abt/v1/refresh/card/message"})
public class RefreshCardMessageController {
    @Autowired
    private RefreshCardMessageService refreshCardMessageService;
    @Autowired
    private RefreshCardMessageConverter refreshCardMessageConverter;

    @PostMapping(value={"/job/createIfAbsent"})
    public ResponseEntity<?> createRefreshCardMessageJobIfAbsent(@Valid @RequestBody RefreshCardMessageDTO refreshCardMessageDTO) {
        RefreshCardMessageDTO refreshCardMessageDO = this.refreshCardMessageConverter.to(refreshCardMessageDTO);
        return ResponseEntityWrapper.wrapperOk((Object)this.refreshCardMessageService.createRefreshCardMessageJobIfAbsent(refreshCardMessageDO));
    }

    @DeleteMapping(value={"/job"})
    public ResponseEntity<?> deleteRefreshCardMessageJob(@NotNull @RequestParam Long cardId) {
        this.refreshCardMessageService.deleteRefreshCardMessageJob(String.valueOf(cardId));
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/job/compensate"})
    public ResponseEntity<?> compensateRefreshCardMessage(@RequestBody List<RefreshCardMessageCompensateDTO> refreshCardMessageCompensateList) {
        this.refreshCardMessageService.compensateRefreshCardMessage(refreshCardMessageCompensateList);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/triggerManual/{jobName}"})
    public String triggerManual(@PathVariable String jobName) {
        return this.refreshCardMessageService.triggerManual(jobName);
    }

    @PostMapping(value={"/refreshCard"})
    public ResponseEntity<?> refreshCard(@RequestBody RefreshCardDto refreshCardDto) {
        this.refreshCardMessageService.refreshCard(refreshCardDto);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/refreshCard/settingSize/{size}"})
    public ResponseEntity<?> settingSize(@PathVariable Integer size) {
        this.refreshCardMessageService.settingSize(size);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/refreshCard/createOrUpdateCardJob"})
    public ResponseEntity<?> createOrUpdateCardJob(@RequestBody CardJob cardJob) throws SchedulerException {
        if (StringUtils.isBlank((CharSequence)cardJob.getTenantId())) {
            AppAuthContext context = AppAuthContextHolder.getContext();
            AuthoredUser authoredUser = context.getAuthoredUser();
            cardJob.setTenantId(authoredUser.getTenantId());
        }
        this.refreshCardMessageService.createOrUpdateCardJob(cardJob);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/refreshCard/updateCardInfo"})
    public ResponseEntity<?> updateCardInfo(@RequestBody CardJob cardJob) {
        if (StringUtils.isBlank((CharSequence)cardJob.getTenantId())) {
            AppAuthContext context = AppAuthContextHolder.getContext();
            AuthoredUser authoredUser = context.getAuthoredUser();
            cardJob.setTenantId(authoredUser.getTenantId());
        }
        this.refreshCardMessageService.updateCardInfo(cardJob);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/open/updateCardByBk"})
    public ResponseEntity<?> updateCardByBk(@RequestBody RefreshCardInfosDTO refreshCardInfos) throws Exception {
        if (StringUtils.isBlank((CharSequence)refreshCardInfos.getTenantId())) {
            AppAuthContext context = AppAuthContextHolder.getContext();
            AuthoredUser authoredUser = context.getAuthoredUser();
            refreshCardInfos.setTenantId(authoredUser.getTenantId());
        }
        this.refreshCardMessageService.updateCardByBk(refreshCardInfos);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/updateTaskWorkItemMessage"})
    public ResponseEntity<?> updateTaskWorkItemMessage(@RequestBody UpdateTaskWorkItemMessageDTO updateDTO) throws Exception {
        this.refreshCardMessageService.updateTaskWorkItemMessage(updateDTO);
        return ResponseEntityWrapper.wrapperOk();
    }
}

