/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.aspect;

import com.digiwin.athena.agiledataquery.annotation.RawResponse;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.model.DapResponse;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class NullToDapResponseReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final HandlerMethodReturnValueHandler delegate;
    private static final String REQUEST_START_TIME = "REQUEST_START_TIME";
    private static final String IS_KG_ROUTED_REQUEST = "IS_KG_ROUTED_REQUEST";
    private static final Class<DapResponse> DAP_RESPONSE_CLASS = DapResponse.class;

    public NullToDapResponseReturnValueHandler(HandlerMethodReturnValueHandler delegate) {
        this.delegate = delegate;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        if (!this.delegate.supportsReturnType(returnType)) {
            return false;
        }
        Class parameterType = returnType.getParameterType();
        return !DAP_RESPONSE_CLASS.isAssignableFrom(parameterType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Class controllerClass = returnType.getContainingClass();
        if (this.shouldWrap(returnValue, returnType)) {
            long currentTime = System.currentTimeMillis();
            int duration = this.calculateDuration(currentTime);
            DapResponse dapResponse = DapResponse.builder().status(Integer.valueOf(200)).statusDescription("OK").response(returnValue).duration(Integer.valueOf(duration)).profile(this.getDWServiceContextProfile()).uuid(UUID.randomUUID().toString()).build();
            this.delegate.handleReturnValue((Object)dapResponse, returnType, mavContainer, webRequest);
        } else {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
        }
    }

    private boolean shouldWrap(Object returnValue, MethodParameter returnType) {
        Class controllerClass = returnType.getContainingClass();
        if (returnValue instanceof DapResponse || returnType.hasMethodAnnotation(RawResponse.class) || controllerClass.isAnnotationPresent(RawResponse.class)) {
            return false;
        }
        try {
            HttpServletRequest request;
            Object isKg;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && Boolean.TRUE.equals(isKg = (request = attributes.getRequest()).getAttribute(IS_KG_ROUTED_REQUEST))) {
                return false;
            }
        }
        catch (Exception attributes) {
            // empty catch block
        }
        if (returnValue instanceof Map) {
            boolean hasCoreFields;
            Map map = (Map)returnValue;
            boolean bl = hasCoreFields = map.containsKey("status") && map.containsKey("statusDescription") && map.containsKey("response");
            if (hasCoreFields) {
                return false;
            }
        }
        return true;
    }

    private int calculateDuration(long currentTime) {
        try {
            HttpServletRequest httpRequest;
            Object startTime;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && (startTime = (httpRequest = attributes.getRequest()).getAttribute(REQUEST_START_TIME)) instanceof Long) {
                return (int)(currentTime - (Long)startTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private Object getDWServiceContextProfile() {
        try {
            return DWServiceContext.getContext().getProfile();
        }
        catch (Exception e) {
            return null;
        }
    }
}

