/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.aspect;

import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SmartRoutingAspect {
    private static final Logger log = LoggerFactory.getLogger(SmartRoutingAspect.class);
    @Autowired
    private KgService kgService;
    @Value(value="${routing.strategy:kg}")
    private String routingStrategy;
    @Value(value="${routing.enabled:false}")
    private boolean routingEnabled;
    @Value(value="${routing.tenantId:}")
    private String routeTenantId;
    private static final String REQUEST_START_TIME = "REQUEST_START_TIME";
    private static final String IS_KG_ROUTED_REQUEST = "IS_KG_ROUTED_REQUEST";

    @Around(value="execution(* com.digiwin.athena.agiledataquery.controller.*.*(..)) && !execution(* *.health(..))")
    public Object routeControllerMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return joinPoint.proceed();
        }
        HttpServletRequest request = attributes.getRequest();
        request.setAttribute(REQUEST_START_TIME, (Object)System.currentTimeMillis());
        if (this.shouldRouteToKg(request)) {
            request.setAttribute(IS_KG_ROUTED_REQUEST, (Object)true);
            Map requestBody = this.getRequestBody(joinPoint, request);
            return this.kgService.forwardToKG(request, requestBody);
        }
        return joinPoint.proceed();
    }

    private boolean shouldRouteToKg(HttpServletRequest request) {
        if (!this.routingEnabled) {
            return false;
        }
        List<String> tenantIds = Arrays.asList(this.routeTenantId.split(","));
        if (tenantIds.contains(AthenaUtils.getTenantId())) {
            return false;
        }
        return "kg".equals(this.routingStrategy);
    }

    private Object routeRequest(ProceedingJoinPoint joinPoint, HttpServletRequest request) throws Throwable {
        List<String> tenantIds = Arrays.asList(this.routeTenantId.split(","));
        if (!this.routingEnabled || tenantIds.contains(AthenaUtils.getTenantId())) {
            return joinPoint.proceed();
        }
        Map requestBody = this.getRequestBody(joinPoint, request);
        if ("kg".equals(this.routingStrategy)) {
            request.setAttribute(IS_KG_ROUTED_REQUEST, (Object)true);
            return this.kgService.forwardToKG(request, requestBody);
        }
        return joinPoint.proceed();
    }

    private Map<String, Object> getRequestBody(ProceedingJoinPoint joinPoint, HttpServletRequest request) {
        Map parameterMap;
        Object[] args;
        HashMap<String, Object> mergedParams = new HashMap<String, Object>();
        for (Object arg : args = joinPoint.getArgs()) {
            if (!(arg instanceof Map)) continue;
            try {
                mergedParams.putAll((Map)arg);
            }
            catch (Exception exception) {}
            break;
        }
        if ("GET".equalsIgnoreCase(request.getMethod()) && (parameterMap = request.getParameterMap()) != null && !parameterMap.isEmpty()) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String key = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                if (values == null) {
                    mergedParams.putIfAbsent(key, "");
                    continue;
                }
                if (values.length == 1) {
                    mergedParams.putIfAbsent(key, values[0]);
                    continue;
                }
                mergedParams.putIfAbsent(key, values);
            }
        }
        return mergedParams;
    }
}

