/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.domain.task.CardGroupGroup;
import com.digiwin.athena.agiledataquery.model.DapResponse;
import com.digiwin.athena.agiledataquery.model.EmailTemplateReq;
import com.digiwin.athena.agiledataquery.utils.DataMapFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ATMCService {
    private static final Logger log = LoggerFactory.getLogger(ATMCService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${atmcUrl}")
    private String atmcUrl;
    @Autowired
    private IamService iamService;

    private String getDefaultLocale() {
        if (StringUtils.endsWithIgnoreCase((CharSequence)this.atmcUrl, (CharSequence)".cn")) {
            return "zh_CN";
        }
        return "zh_TW";
    }

    public void noticeSuperAdminUserIntegrityCheckResult(JSONObject param) {
        log.info("sendUserIntegrityCheckResultMessage param:{}", (Object)param);
        try {
            if (param == null) {
                return;
            }
            String tenantId = param.getString("tenantId");
            Integer userErrors = param.getInteger("userErrors");
            Integer deptErrors = param.getInteger("deptErrors");
            Integer dutyErrors = param.getInteger("dutyErrors");
            JSONArray superadmins = param.getJSONArray("superadmins");
            if (superadmins == null || superadmins.size() == 0) {
                log.info("sendUserIntegrityCheckResultMessage superadmins empty");
                return;
            }
            List zh_tw = this.getUserIntegrityCheckMessage(userErrors, deptErrors, dutyErrors, "zh_TW");
            if (CollectionUtils.isEmpty((Collection)zh_tw)) {
                log.info("sendUserIntegrityCheckResultMessage no errors");
                return;
            }
            List zh_CN = this.getUserIntegrityCheckMessage(userErrors, deptErrors, dutyErrors, "zh_CN");
            HashMap<String, Object> messageSendParam = new HashMap<String, Object>();
            HashMap<String, List> message = new HashMap<String, List>();
            message.put("zhCN", zh_CN);
            message.put("zhTW", zh_tw);
            message.put("enUS", new ArrayList());
            messageSendParam.put("message", message);
            messageSendParam.put("source", "UserIntegrityCheck");
            HashMap<String, Object> messageDetail = new HashMap<String, Object>();
            messageDetail.put("userErrorNum", userErrors);
            messageDetail.put("userErrorDatas", param.get((Object)"userErrorDatas"));
            messageDetail.put("deptErrorNum", deptErrors);
            messageDetail.put("deptErrorDatas", param.get((Object)"deptErrorDatas"));
            messageDetail.put("dutyErrorNum", dutyErrors);
            messageDetail.put("dutyErrorDatas", param.get((Object)"dutyErrorData"));
            messageSendParam.put("messageDetail", messageDetail);
            ArrayList<JSONObject> users = new ArrayList<JSONObject>();
            ArrayList<JSONObject> emailUsers = new ArrayList<JSONObject>();
            for (int i = 0; i < superadmins.size(); ++i) {
                JSONObject jsonObject = superadmins.getJSONObject(i);
                String language = jsonObject.getString("language");
                if (StringUtils.isEmpty((CharSequence)language)) {
                    jsonObject.put("locale", (Object)this.getDefaultLocale());
                } else {
                    jsonObject.put("locale", (Object)language);
                }
                if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("email")) && !StringUtils.endsWithIgnoreCase((CharSequence)jsonObject.getString("email"), (CharSequence)"@digiwin.com")) {
                    jsonObject.put("emailAddress", (Object)jsonObject.getString("email"));
                    emailUsers.add(jsonObject);
                }
                users.add(jsonObject);
            }
            String tenantToken = this.iamService.getTenantToken(tenantId);
            try {
                if (CollectionUtils.isNotEmpty(users)) {
                    messageSendParam.put("users", users);
                    this.sendIMMessage(messageSendParam, tenantToken, tenantId);
                }
            }
            catch (Exception e) {
                log.error("sendIMMessage error:{}", (Object)e.getMessage());
            }
            try {
                if (CollectionUtils.isNotEmpty(emailUsers)) {
                    messageSendParam.put("users", emailUsers);
                    this.sendEmail(messageSendParam, tenantToken, tenantId);
                }
            }
            catch (Exception e) {
                log.error("sendEmail error:{}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("sendUserIntegrityCheckResultMessage error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<String> getUserIntegrityCheckMessage(Integer userErrors, Integer deptErrors, Integer dutyErrors, String locale) {
        ArrayList<String> result = new ArrayList<String>();
        if (userErrors != null && userErrors != 0) {
            if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_TW")) {
                result.add("\u5171" + userErrors + "\u4f4d\u7528\u6236\u672a\u8207\u54e1\u5de5\u95dc\u806f");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_CN")) {
                result.add("\u5171" + userErrors + "\u4f4d\u7528\u6237\u672a\u4e0e\u5458\u5de5\u5173\u8054");
            } else {
                result.add("A total of " + userErrors + " users are not associated with employees");
            }
        }
        if (deptErrors != null && deptErrors != 0) {
            if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_TW")) {
                result.add("\u5171" + deptErrors + "\u4f4d\u54e1\u5de5\u672a\u8a2d\u5b9a\u6240\u5c6c\u90e8\u9580");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_CN")) {
                result.add("\u5171" + deptErrors + "\u4f4d\u5458\u5de5\u672a\u8bbe\u5b9a\u6240\u5c5e\u90e8\u95e8");
            } else {
                result.add("A total of " + deptErrors + " employees have not set their departments");
            }
        }
        if (dutyErrors != null && dutyErrors != 0) {
            if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_TW")) {
                result.add("\u5171" + dutyErrors + "\u500b\u8077\u80fd\u7121\u5c0d\u61c9\u54e1\u5de5");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)"zh_CN")) {
                result.add("\u5171" + dutyErrors + "\u4e2a\u804c\u80fd\u65e0\u5bf9\u5e94\u5458\u5de5");
            } else {
                result.add("There are " + dutyErrors + " functions without corresponding employees");
            }
        }
        return result;
    }

    public List<CardGroupGroup> getGroupDimension(String routerKey) {
        String tenantToken = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", tenantToken);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        log.info("getGroupDimension tenantId:{}, url:{}", (Object)routerKey, (Object)(this.atmcUrl + "/api/atmc/v1/backlog/group/dimension"));
        ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/backlog/group/dimension", HttpMethod.GET, requestEntity, DapResponse.class, new Object[0]);
        DapResponse body = (DapResponse)resEntity.getBody();
        log.info("getGroupDimension result:{}", (Object)body);
        List cardGroupGroups = JSONObject.parseArray((String)JSON.toJSONString((Object)body.getResponse()), CardGroupGroup.class);
        return cardGroupGroups;
    }

    public Object sendIMMessage(Object message, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity(message, (MultiValueMap)headers);
        log.info("sendIMMessage tenantId:{}, url:{}, requestParam:{}", new Object[]{routerKey, this.atmcUrl + "/api/atmc/v1/eoc/notice/sendMessage", message});
        ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/eoc/notice/sendMessage", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("sendIMMessage result:{}", body);
        return body;
    }

    public Object sendEmail(Object message, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity(message, (MultiValueMap)headers);
        log.info("sendEmail tenantId:{}, url:{}, requestParam:{}", new Object[]{routerKey, this.atmcUrl + "/api/atmc/v1/eoc/notice/sendEmail", message});
        ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/eoc/notice/sendEmail", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("sendEmail result:{}", body);
        return body;
    }

    public Object addEmailTemplate(EmailTemplateReq params) {
        DataMapFilter.LoginInfo loginInfo;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String routerKey = request.getHeader("routerKey");
        String token = request.getHeader("token");
        if (StringUtils.isEmpty((CharSequence)token) && StringUtils.isEmpty((CharSequence)(token = request.getHeader("Digi-Middleware-Auth-User")))) {
            token = request.getHeader("digi-middleware-auth-user");
        }
        if (null == token) {
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        }
        if (null == token && null != (loginInfo = DataMapFilter.getLoginInfo())) {
            token = loginInfo.getToken();
            routerKey = loginInfo.getRouterKey();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        log.info("\u65b0\u589e\u90ae\u4ef6\u7ba1\u7406\u6a21\u677f tenantId:{}, url:{}, requestParam:{}", new Object[]{routerKey, this.atmcUrl + "/api/atmc/v1/email/template", JSON.toJSONString((Object)params)});
        Object body = null;
        try {
            ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/email/template", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            body = resEntity.getBody();
            log.info("\u65b0\u589e\u90ae\u4ef6\u7ba1\u7406\u6a21\u677f result:{}", (Object)JSON.toJSONString((Object)body));
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u90ae\u4ef6\u7ba1\u7406\u6a21\u677f\u51fa\u9519\uff1a", (Throwable)e);
        }
        return body;
    }

    public Object cacheReset(String routerKey, String pattern) {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        log.info("cacheReset tenantId:{}, url:{}, requestParam:{}", new Object[]{routerKey, this.atmcUrl + "/api/atmc/v1/cache/reset/withPattern", pattern});
        ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/cache/reset/withPattern?pattern=" + pattern, HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("sendEmail result:{}", body);
        return body;
    }
}

