/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DMCUtils {
    private static final Logger log = LoggerFactory.getLogger(DMCUtils.class);
    @Value(value="${dmcUrl}")
    private String dmcUrl;
    @Value(value="${iamApToken}")
    private String appToken;
    @Value(value="${dmcBucket}")
    private String dmcBucket;
    @Autowired
    private RestTemplate dmcRestTemplate;

    public JSONObject deleteDmcFile(String fileId, String token) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.dmcBucket + "/delete/" + fileId;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)headers), JSONObject.class, new Object[0]);
        return (JSONObject)restRes.getBody();
    }
}

