/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="interceptor")
public class InterceptorConfig {
    private static final Logger log = LoggerFactory.getLogger(InterceptorConfig.class);
    private List<String> excludePaths = new ArrayList();
    @Value(value="${INTERCEPTOR_EXTRA_EXCLUDE_PATHS}")
    private String extraExcludePaths;

    public List<String> getFinalExcludePaths() {
        ArrayList<String> finalPaths = new ArrayList<String>(this.excludePaths);
        log.info("\u8def\u5f84: {}", (Object)this.extraExcludePaths);
        if (StringUtils.hasText((String)this.extraExcludePaths)) {
            String[] extraPaths;
            for (String path : extraPaths = this.extraExcludePaths.split(",")) {
                String trimmedPath = path.trim();
                if (!StringUtils.hasText((String)trimmedPath)) continue;
                finalPaths.add(trimmedPath);
                log.info("\u6dfb\u52a0\u73af\u5883\u53d8\u91cf\u914d\u7f6e\u7684\u6392\u9664\u8def\u5f84: {}", (Object)trimmedPath);
            }
        }
        return finalPaths;
    }

    @PostConstruct
    public void init() {
        log.info("=== \u62e6\u622a\u5668\u914d\u7f6e\u521d\u59cb\u5316 ===");
        log.info("\u57fa\u7840\u6392\u9664\u8def\u5f84\u6570\u91cf: {}", (Object)this.excludePaths.size());
        log.info("\u73af\u5883\u53d8\u91cf\u989d\u5916\u6392\u9664\u8def\u5f84: {}", (Object)this.extraExcludePaths);
        log.info("\u6700\u7ec8\u6392\u9664\u8def\u5f84\u6570\u91cf: {}", (Object)this.getFinalExcludePaths().size());
        log.info("=== \u62e6\u622a\u5668\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210 ===");
    }

    public List<String> getExcludePaths() {
        return this.excludePaths;
    }

    public String getExtraExcludePaths() {
        return this.extraExcludePaths;
    }

    public void setExcludePaths(List<String> excludePaths) {
        this.excludePaths = excludePaths;
    }

    public void setExtraExcludePaths(String extraExcludePaths) {
        this.extraExcludePaths = extraExcludePaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterceptorConfig)) {
            return false;
        }
        InterceptorConfig other = (InterceptorConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$excludePaths = this.getExcludePaths();
        List other$excludePaths = other.getExcludePaths();
        if (this$excludePaths == null ? other$excludePaths != null : !((Object)this$excludePaths).equals(other$excludePaths)) {
            return false;
        }
        String this$extraExcludePaths = this.getExtraExcludePaths();
        String other$extraExcludePaths = other.getExtraExcludePaths();
        return !(this$extraExcludePaths == null ? other$extraExcludePaths != null : !this$extraExcludePaths.equals(other$extraExcludePaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InterceptorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $excludePaths = this.getExcludePaths();
        result = result * 59 + ($excludePaths == null ? 43 : ((Object)$excludePaths).hashCode());
        String $extraExcludePaths = this.getExtraExcludePaths();
        result = result * 59 + ($extraExcludePaths == null ? 43 : $extraExcludePaths.hashCode());
        return result;
    }

    public String toString() {
        return "InterceptorConfig(excludePaths=" + this.getExcludePaths() + ", extraExcludePaths=" + this.getExtraExcludePaths() + ")";
    }
}

