/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class MongoTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(MongoTemplateConfig.class);
    @Value(value="${spring.data.mongodb.uri}")
    private String mongoUri;
    @Value(value="${spring.data.mongodb.database}")
    private String systemDatabase;
    @Value(value="${spring.data.mongodb.tenant.database}")
    private String tenantDatabase;
    @Value(value="${spring.data.mongodb.options.min-connections-per-host:5}")
    private int minConnectionsPerHost;
    @Value(value="${spring.data.mongodb.options.max-connections-per-host:50}")
    private int maxConnectionsPerHost;
    @Value(value="${spring.data.mongodb.options.connect-timeout:5000}")
    private int connectTimeout;
    @Value(value="${spring.data.mongodb.options.socket-timeout:10000}")
    private int socketTimeout;
    @Value(value="${spring.data.mongodb.options.max-wait-time:5000}")
    private int maxWaitTime;
    @Value(value="${spring.data.mongodb.options.server-selection-timeout:10000}")
    private int serverSelectionTimeout;

    @Bean(value={"mongoTemplate"})
    @Primary
    public MongoTemplate mongoTemplate() {
        try {
            log.info("\u521b\u5efa\u7cfb\u7edf\u6570\u636e\u5e93 MongoTemplate\uff0cURI: {}, \u6570\u636e\u5e93: {}", (Object)this.mongoUri, (Object)this.systemDatabase);
            MongoClientSettings settings = this.createMongoClientSettings();
            MongoClientImpl client = new MongoClientImpl(settings, null);
            MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.systemDatabase);
            this.configureConverter(mongoTemplate);
            log.info("\u7cfb\u7edf\u6570\u636e\u5e93 MongoTemplate \u521b\u5efa\u6210\u529f");
            return mongoTemplate;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7cfb\u7edf\u6570\u636e\u5e93 MongoTemplate \u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("MongoDB\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", e);
        }
    }

    @Bean(value={"mongoTemplateTenant"})
    public MongoTemplate mongoTemplateTenant() {
        log.info("\u521b\u5efa\u79df\u6237\u6570\u636e\u5e93 MongoTemplate\uff0cURI: {}, \u6570\u636e\u5e93: {}", (Object)this.mongoUri, (Object)this.tenantDatabase);
        MongoClientSettings settings = this.createMongoClientSettings();
        MongoClientImpl client = new MongoClientImpl(settings, null);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.tenantDatabase);
        this.configureConverter(mongoTemplate);
        return mongoTemplate;
    }

    private MongoClientSettings createMongoClientSettings() {
        return MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.mongoUri)).applyToConnectionPoolSettings(builder -> builder.minSize(this.minConnectionsPerHost).maxSize(this.maxConnectionsPerHost).maxWaitTime((long)this.maxWaitTime, TimeUnit.MILLISECONDS).maxConnectionIdleTime(60000L, TimeUnit.MILLISECONDS).maxConnectionLifeTime(300000L, TimeUnit.MILLISECONDS)).applyToSocketSettings(builder -> builder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.socketTimeout, TimeUnit.MILLISECONDS)).applyToServerSettings(builder -> builder.heartbeatFrequency(10000L, TimeUnit.MILLISECONDS)).build();
    }

    private void configureConverter(MongoTemplate mongoTemplate) {
        MongoConverter converter = mongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
    }
}

