/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.service.IActionService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/Action"})
public class ActionController {
    @Autowired
    private IActionService actionService;

    @GetMapping(value={"/metadata"})
    public Object postMetadata(@RequestParam String actionId) throws Exception {
        if (StringUtils.isEmpty((Object)actionId)) {
            return null;
        }
        return this.actionService.getMetadata(actionId);
    }

    @PostMapping(value={"/queryExecutionPath"})
    public Object postQueryExecutionPath(@RequestBody Map<String, Object> params) throws Exception {
        String actionId = (String)params.get("actionId");
        String tenantId = (String)params.get("tenantId");
        List existingActionParams = (List)params.get("existingActionParams");
        List existingSysParams = (List)params.get("existingSysParams");
        return this.actionService.postQueryExecutionPath(actionId, tenantId, existingActionParams, existingSysParams);
    }

    @PostMapping(value={"/findLastNodeShapeType"})
    public Object postFindLastNodeShapeType(@RequestBody Map<String, Object> params) throws Exception {
        String nodeType = (String)params.get("nodeType");
        String reportRelationFir = (String)params.get("reportRelationFir");
        String reportRelationSec = (String)params.get("reportRelationSec");
        String reportRelationThi = (String)params.get("reportRelationThi");
        String reportRelationFou = (String)params.get("reportRelationFou");
        return this.actionService.postFindLastNodeShapeType(nodeType, reportRelationFir, reportRelationSec, reportRelationThi, reportRelationFou);
    }

    @PostMapping(value={"/metaDataStruct"})
    public Object postMetaDataStruct(@RequestBody Map<String, Object> params) throws Exception {
        List actionIds = (List)params.get("actionIds");
        return this.actionService.postMetaDataStruct(actionIds);
    }

    @PostMapping(value={"/metricActionData"})
    public Object postMetricActionData(@RequestBody Map<String, Object> params) throws Exception {
        List actionIds = (List)params.get("actionIds");
        return this.actionService.postMetricActionData(actionIds);
    }
}

