/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.domain.activity.Activity;
import com.digiwin.athena.agiledataquery.dto.ApplicationRelationByTypeAndCodeDTO;
import com.digiwin.athena.agiledataquery.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.agiledataquery.dto.QueryApplicationsByCodesDTO;
import com.digiwin.athena.agiledataquery.dto.QueryApplicationsNameByCodeListDTO;
import com.digiwin.athena.agiledataquery.dto.QueryDigitalStaffByCodeDTO;
import com.digiwin.athena.agiledataquery.po.AppRelationBatchPo;
import com.digiwin.athena.agiledataquery.service.IApplicationService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/app"})
public class ApplicationController {
    @Autowired
    private IApplicationService applicationService;

    @GetMapping(value={"/applicationByTypeAndCode"})
    public Object getApplicationByTypeAndCode(@RequestParam String type, @RequestParam String code, @RequestParam String lang, @RequestParam String subType, @RequestParam List<String> codeList) {
        if (!CollectionUtils.isEmpty(codeList)) {
            return this.applicationService.getApplicationByTypeAndCode(type, subType, codeList);
        }
        if (!StringUtils.isEmpty((Object)lang)) {
            return this.applicationService.getApplicationByTypeAndCode(type, code, lang);
        }
        return this.applicationService.getApplicationByTypeAndCode(type, code);
    }

    @GetMapping(value={"/applicationsMapByTypeAndCodes"})
    public Object getApplicationsMapByTypeAndCodes(@RequestParam String type, @RequestParam Set<String> codes, @RequestParam Map<String, Activity> activityMap) {
        return this.applicationService.getApplicationsMapByTypeAndCodes(type, codes, activityMap);
    }

    @GetMapping(value={"/applicationsByTypeAndCode"})
    public Object getApplicationsByTypeAndCode(@RequestParam String type, @RequestParam String code) {
        return this.applicationService.getApplicationsByTypeAndCode(type, code);
    }

    @GetMapping(value={"/applicationsByCodes"})
    public Object getApplicationsByCodes(@RequestParam List<String> codes) {
        return this.applicationService.getApplicationsByCodes(codes);
    }

    @GetMapping(value={"/applicationByCode"})
    public Object getApplicationByCode(@RequestParam String code, @RequestParam String tenantId) {
        if (StringUtils.isEmpty((Object)tenantId)) {
            return this.applicationService.getApplicationByCode(code);
        }
        return this.applicationService.getApplicationByCode(code, tenantId);
    }

    @GetMapping(value={"/applicationFunctionCtrlByBizCode"})
    public Object getApplicationFunctionCtrlByBizCode(@RequestParam String code) {
        return this.applicationService.getApplicationFunctionCtrlByBizCode(code);
    }

    @GetMapping(value={"/applicationFunctionCtrlByAppCode"})
    public Object getApplicationFunctionCtrlByAppCode(@RequestParam String code) {
        return this.applicationService.getApplicationFunctionCtrlByAppCode(code);
    }

    @GetMapping(value={"/applicationRecommendations"})
    public Object getApplicationRecommendations() {
        return this.applicationService.getApplicationRecommendations();
    }

    @GetMapping(value={"/applicationRelationsMapByTypeAndCodesAndLang"})
    public Object getApplicationRelationsMapByTypeAndCodesAndLang(@RequestParam String type, @RequestParam Set<String> codes, @RequestParam String lang) {
        return this.applicationService.getApplicationRelationsMapByTypeAndCodesAndLang(type, codes, lang);
    }

    @GetMapping(value={"/applicationRelationsByTypeAndCodeAndLang"})
    public Object getApplicationRelationsByTypeAndCodeAndLang(@RequestParam String type, @RequestParam String code, @RequestParam String lang) {
        return this.applicationService.getApplicationRelationsByTypeAndCodeAndLang(type, code, lang);
    }

    @GetMapping(value={"/applicationByTypeAndCodeAndLang"})
    public Object getApplicationByTypeAndCodeAndLang(@RequestParam String type, @RequestParam String code, @RequestParam String lang) {
        return this.applicationService.getApplicationByTypeAndCodeAndLang(type, code, lang);
    }

    @GetMapping(value={"/applicationRelationsMapByApplicationAndLang"})
    public Object getApplicationRelationsMapByApplicationAndLang(@RequestParam List<String> codes, @RequestParam String localeStr) {
        return this.applicationService.getApplicationRelationsMapByApplicationAndLang(codes, localeStr);
    }

    @GetMapping(value={"/applicationRelationByApplicationAndLang"})
    public Object getApplicationRelationByApplicationAndLang(@RequestParam String code, @RequestParam String localeStr) {
        return this.applicationService.getApplicationRelationByApplicationAndLang(code, localeStr);
    }

    @RequestMapping(value={"/getLicenseKey"})
    public Object getLicenseKey(@RequestBody JSONObject params) throws Exception {
        String tenantId = params.getString("tenantId");
        String requestFrom = params.getString("requestFrom");
        String key = params.getString("key");
        long timestamp = params.getLong("timestamp");
        if (StringUtils.isEmpty((Object)requestFrom)) {
            return this.applicationService.getLicenseKey(tenantId);
        }
        return this.applicationService.getLicenseKey(tenantId, requestFrom, key, timestamp);
    }

    @PostMapping(value={"/setLicenseKey"})
    public Object postSetLicenseKey(@RequestBody JSONObject request) throws Exception {
        String tenantId = request.getString("tenantId");
        if (StringUtils.isEmpty((Object)tenantId)) {
            return this.applicationService.postSetLicenseKey();
        }
        return this.applicationService.postSetLicenseKey(tenantId);
    }

    @GetMapping(value={"/"})
    public Object get(@RequestParam String code) {
        return this.applicationService.get(code);
    }

    @GetMapping(value={"/list"})
    public Object getList(@RequestParam Set<String> applicationCodeList) {
        return this.applicationService.getList(applicationCodeList);
    }

    @GetMapping(value={"/byNameAndTags"})
    public Object getByNameAndTags(@RequestParam String applicationName, @RequestParam List<String> tags) {
        return this.applicationService.getByNameAndTags(applicationName, tags);
    }

    @GetMapping(value={"/applicationMechanismByApplicationCode"})
    public Object getApplicationMechanismByApplicationCode(@RequestParam String applicationCode) {
        return this.applicationService.getApplicationMechanismByApplicationCode(applicationCode);
    }

    @PostMapping(value={"/applicationMechanismByApplicationCodes"})
    public Object postApplicationMechanismByApplicationCodes(@RequestBody Map<String, Object> param) {
        List applicationCodes = (List)param.get("applicationCodes");
        return this.applicationService.postApplicationMechanismByApplicationCodes(applicationCodes);
    }

    @GetMapping(value={"/applicationMechanismByMechanismCode"})
    public Object getApplicationMechanismByMechanismCode(@RequestParam String mechanismCode) {
        return this.applicationService.getApplicationMechanismByMechanismCode(mechanismCode);
    }

    @GetMapping(value={"/applicationInfo"})
    public Object getApplicationInfo(@RequestParam String code) {
        return this.applicationService.getApplicationInfo(code);
    }

    @GetMapping(value={"/taskCode"})
    public Object getTaskCode(@RequestParam String appCode) {
        return this.applicationService.getTaskCode(appCode);
    }

    @GetMapping(value={"/mechanismCode"})
    public Object getMechanismCode(@RequestParam String appCode) {
        return this.applicationService.getMechanismCode(appCode);
    }

    @GetMapping(value={"/monitorRuleCode"})
    public Object getMonitorRuleCode(@RequestParam String appCode) {
        return this.applicationService.getMonitorRuleCode(appCode);
    }

    @PostMapping(value={"/applicationRelationsByCodesAndType"})
    public Object postApplicationRelationsByCodesAndType(@RequestBody ApplicationRelationQueryDTO applicationRelationQueryDTO) {
        return this.applicationService.postApplicationRelationsByCodesAndType(applicationRelationQueryDTO);
    }

    @GetMapping(value={"/appCodeByTaskCode"})
    public Object getAppCodeByTaskCode(@RequestParam String code) {
        return this.applicationService.getAppCodeByTaskCode(code);
    }

    @GetMapping(value={"/appCodeByMechanismCode"})
    public Object getAppCodeByMechanismCode(@RequestParam String code) {
        return this.applicationService.getAppCodeByMechanismCode(code);
    }

    @GetMapping(value={"appCodeByMonitorRuleCode"})
    public Object getAppCodeByMonitorRuleCode(@RequestParam String code) {
        return this.applicationService.getAppCodeByMonitorRuleCode(code);
    }

    @GetMapping(value={"/applicationRelation"})
    public Object getApplicationRelation(@RequestParam List<String> appCodes, @RequestParam String tenantVersion, @RequestParam List<String> codes, @RequestParam String type, @RequestParam String subType) {
        if (CollectionUtils.isEmpty(appCodes)) {
            return this.applicationService.getApplicationRelation(codes, tenantVersion);
        }
        return this.applicationService.getApplicationRelation(appCodes, codes, type, subType);
    }

    @PostMapping(value={"/applicationRelation"})
    public Object postApplicationRelation(@RequestBody Map<String, Object> param) {
        List appCodes = (List)param.get("appCodes");
        return this.applicationService.postApplicationRelation(appCodes);
    }

    @GetMapping(value={"/flowCode"})
    public Object getFlowCode(@RequestParam String appCode) {
        return this.applicationService.getFlowCode(appCode);
    }

    @GetMapping(value={"/appCodeByFlowCode"})
    public Object getAppCodeByFlowCode(@RequestParam String code) {
        return this.applicationService.getAppCodeByFlowCode(code);
    }

    @GetMapping(value={"/variableCode"})
    public Object getVariableCode(@RequestParam String appCode) {
        return this.applicationService.getVariableCode(appCode);
    }

    @GetMapping(value={"/notCommonAppCode"})
    public Object getNotCommonAppCode() {
        return this.applicationService.getNotCommonAppCode();
    }

    @GetMapping(value={"/monitorRulesRelatedToTask"})
    public Object getMonitorRulesRelatedToTask(@RequestParam String appCode) {
        return this.applicationService.getMonitorRulesRelatedToTask(appCode);
    }

    @PostMapping(value={"/queryDigitalStaffByCode"})
    public Object postQueryDigitalStaffByCode(@RequestBody QueryDigitalStaffByCodeDTO dto) {
        return this.applicationService.postQueryDigitalStaffByCode(dto);
    }

    @GetMapping(value={"/appCodeByTypeAndCode"})
    public Object getAppCodeByTypeAndCode(@RequestParam String type, @RequestParam String code) {
        return this.applicationService.getAppCodeByTypeAndCode(type, code);
    }

    @GetMapping(value={"/paradigmByTypeAndAppCode"})
    public Object getParadigmByTypeAndAppCode(@RequestParam String type, @RequestParam String appCode) {
        return this.applicationService.getParadigmByTypeAndAppCode(type, appCode);
    }

    @GetMapping(value={"/appCodeByApplication"})
    public Object getAppCodeByApplication(@RequestParam String application) {
        return this.applicationService.getAppCodeByApplication(application);
    }

    @GetMapping(value={"/applicationRelationByTypeAndAppCodeAndVersion"})
    public Object getApplicationRelationByTypeAndAppCodeAndVersion(@RequestParam String type, @RequestParam String appCode, @RequestParam String version) {
        return this.applicationService.getApplicationRelationByTypeAndAppCodeAndVersion(type, appCode, version);
    }

    @GetMapping(value={"/applicationRelationByTypeAndAppCode"})
    public Object getApplicationRelationByTypeAndAppCode(@RequestParam String type, @RequestParam String appCode, @RequestParam List<String> appCodes, @RequestParam String tenantId) {
        if (CollectionUtils.isEmpty(appCodes)) {
            if (!StringUtils.isEmpty((Object)tenantId)) {
                return this.applicationService.getApplicationRelationByTypeAndAppCode(tenantId, type, appCode);
            }
            return this.applicationService.getApplicationRelationByTypeAndAppCode(type, appCode);
        }
        return this.applicationService.getApplicationRelationByTypeAndAppCode(type, appCodes);
    }

    @PostMapping(value={"/appRelationUpdate"})
    public Object postAppRelationUpdate(@RequestBody AppRelationBatchPo request) {
        return this.applicationService.postAppRelationUpdate(request);
    }

    @GetMapping(value={"/applicationRelationByType"})
    public Object getApplicationRelationByType(@RequestParam String type) {
        return this.applicationService.getApplicationRelationByType(type);
    }

    @PostMapping(value={"/configByApplicationCustomized"})
    public Object postConfigByApplicationCustomized() {
        return this.applicationService.postConfigByApplicationCustomized();
    }

    @PostMapping(value={"/configByGroupApplicationCustomized"})
    public Object postConfigByGroupApplicationCustomized() {
        return this.applicationService.postConfigByGroupApplicationCustomized();
    }

    @PostMapping(value={"/allApplications"})
    public Object postAllApplications() {
        return this.applicationService.postAllApplications();
    }

    @PostMapping(value={"/applicationRelationByTypeAndCode"})
    public Object postApplicationRelationByTypeAndCode(@RequestBody ApplicationRelationByTypeAndCodeDTO dto) {
        return this.applicationService.postApplicationRelationByTypeAndCode(dto);
    }

    @PostMapping(value={"/applicationRelationByDDSM"})
    public Object postApplicationRelationByDDSM(@RequestBody AppRelationBatchPo request) {
        return this.applicationService.postApplicationRelationByDDSM(request);
    }

    @PostMapping(value={"/queryApplicationsNameByCodeList"})
    public Object postQueryApplicationsNameByCodeList(@RequestBody QueryApplicationsNameByCodeListDTO request) {
        return this.applicationService.postQueryApplicationsNameByCodeList(request);
    }

    @GetMapping(value={"/appByMechanismCode"})
    public Object getAppByMechanismCode(@RequestParam String mechanismCode) {
        return this.applicationService.getAppByMechanismCode(mechanismCode);
    }

    @GetMapping(value={"/appByActivityId"})
    public Object getAppByActivityId(@RequestParam String activityId) {
        return this.applicationService.getAppByActivityId(activityId);
    }

    @PostMapping(value={"/queryApplicationsByCodes"})
    public Object postQueryApplicationsByCodes(@RequestBody QueryApplicationsByCodesDTO request) {
        return this.applicationService.postQueryApplicationsByCodes(request);
    }
}

