/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.service.ICommandService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/command"})
public class CommandController {
    private static final Logger log = LoggerFactory.getLogger(CommandController.class);
    @Autowired
    private ICommandService commandService;

    @GetMapping(value={"/queryCommandIntentions"})
    public Object queryCommandIntentions(@RequestParam(required=false) String userId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        log.info("queryCommandIntentions called by user: {}", (Object)userId);
        return this.commandService.queryCommandIntentions(userId);
    }

    @GetMapping(value={"/dataSetCommandIntentions"})
    public Object dataSetCommandIntentions(@RequestParam(required=false) String appCode, @RequestParam(required=false) String version) throws Exception {
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            throw new DWBusinessException("500", "\u5165\u53c2appCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.commandService.dataSetCommandIntentions(appCode, version);
    }

    @GetMapping(value={"/queryAllCommandIntentions"})
    public Object queryAllCommandIntentions(@RequestParam(required=false) String userId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        log.info("queryAllCommandIntentions called by user: {}", (Object)userId);
        return this.commandService.queryAllCommandIntentions(userId);
    }
}

