/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.model.dataBoard.DataBoardGroupConfig;
import com.digiwin.athena.agiledataquery.model.dataCollectGroup.DelConfigDTO;
import com.digiwin.athena.agiledataquery.service.IDataBoardGroupService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/dataBoardGroup"})
public class DataBoardGroupController {
    private static final Logger log = LoggerFactory.getLogger(DataBoardGroupController.class);
    @Autowired
    private IDataBoardGroupService dataBoardGroupService;

    @GetMapping(value={"/queryDataBoardGroupConfig"})
    public Object queryDataBoardGroupConfig() throws Exception {
        try {
            return this.dataBoardGroupService.getQueryDataBoardGroupConfig();
        }
        catch (DWBusinessException | IllegalAccessException | NoSuchFieldException e) {
            log.error("\u67e5\u8be2\u6536\u85cf\u6570\u636e\u5206\u7ec4\u914d\u7f6e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    @PostMapping(value={"/addDataBoardGroupConfig"})
    public Object addDataBoardGroupConfig(@RequestBody Map<String, Object> params) throws Exception {
        List config = JSON.parseArray((String)JSON.toJSONString((Object)params.get("config")), DataBoardGroupConfig.class);
        if (config == null || config.isEmpty()) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardGroupService.postAddDataBoardGroupConfig(config);
    }

    @PostMapping(value={"/removeDataBoardGroupConfig"})
    public Object removeDataBoardGroupConfig(@RequestBody Map<String, Object> params) throws Exception {
        DelConfigDTO delConfig = (DelConfigDTO)JSON.parseObject((String)JSON.toJSONString((Object)params.get("delConfig")), DelConfigDTO.class);
        if (delConfig == null) {
            throw new DWBusinessException("500", "\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardGroupService.postRemoveDataBoardGroupConfig(delConfig);
    }

    @PostMapping(value={"/batchAddDataBoardGroupConfig"})
    public Object batchAddDataBoardGroupConfig(@RequestBody Map<String, Object> params) throws Exception {
        List configList = JSON.parseArray((String)JSON.toJSONString((Object)params.get("configList")), DataBoardGroupConfig.class);
        if (configList == null || configList.isEmpty()) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardGroupService.postAddDataBoardGroupConfig(configList);
    }

    @PostMapping(value={"/deleteDataBoardGroupConfig"})
    public Object deleteDataBoardGroupConfig(@RequestBody Map<String, Object> params) throws Exception {
        DelConfigDTO delConfig = (DelConfigDTO)JSON.parseObject((String)JSON.toJSONString((Object)params.get("delConfig")), DelConfigDTO.class);
        if (delConfig == null) {
            throw new DWBusinessException("500", "\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardGroupService.postRemoveDataBoardGroupConfig(delConfig);
    }
}

