/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.model.file.FileDocument;
import com.digiwin.athena.agiledataquery.service.IFileService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/agiledataquery/file"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private IFileService fileService;

    @PostMapping(value={"/save"})
    public Object save(@RequestBody FileDocument fileObj) throws DWBusinessException {
        if (fileObj == null) {
            throw new DWBusinessException("500", "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.fileService.saveOrUpdate(fileObj);
    }

    @GetMapping(value={"/get"})
    public Object get(@RequestParam(required=false) String fileId, @RequestParam(required=false) String dmcId) throws DWBusinessException {
        if (StringUtils.isBlank((CharSequence)fileId) && StringUtils.isBlank((CharSequence)dmcId)) {
            throw new DWBusinessException("500", "\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.fileService.getById(fileId, dmcId);
    }

    @PostMapping(value={"/list"})
    public Object list(@RequestBody FileDocument fileObj) throws DWBusinessException {
        if (fileObj == null) {
            throw new DWBusinessException("500", "\u6587\u4ef6\u67e5\u8be2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.fileService.list(fileObj);
        return list;
    }

    @PostMapping(value={"/delete"})
    public Object delete(@RequestBody FileDocument fileObj) throws DWBusinessException {
        return this.fileService.delete(fileObj);
    }
}

