/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.domain.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.agiledataquery.domain.secondCalculate.ActionRecast;
import com.digiwin.athena.agiledataquery.model.pushMetadata.ActionIntentions;
import com.digiwin.athena.agiledataquery.model.sence.ReportSceneDTO;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/scene"})
public class SceneController {
    private static final Logger log = LoggerFactory.getLogger(SceneController.class);
    @Autowired
    private ISceneService sceneService;

    @PostMapping(value={"/createSceneMaps"})
    public Object createSceneMaps(@RequestBody Map<String, Object> params) throws Exception {
        ReportSceneDTO reportScene;
        ReportSceneDTO reportSceneDTO = reportScene = params.get("reportScene") == null ? null : (ReportSceneDTO)params.get("reportScene");
        if (reportScene == null) {
            throw new DWBusinessException("500", "\u573a\u666f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.createSceneMaps(reportScene);
    }

    @PostMapping(value={"/querySceneMaps"})
    public Object querySceneMaps(@RequestBody Map<String, Object> params) throws Exception {
        String code = params.getOrDefault("code", "").toString();
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new DWBusinessException("500", "\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.querySceneMaps(code);
    }

    @PostMapping(value={"/querySceneByTemplateAndTarget"})
    public Object querySceneByTemplateAndTarget(@RequestBody Map<String, Object> params) throws Exception {
        List dimension;
        String templateCode = params.getOrDefault("templateCode", "").toString();
        String targetId = params.getOrDefault("targetId", "").toString();
        List list = dimension = params.get("dimension") == null ? null : (List)params.get("dimension");
        if (templateCode == null || templateCode.trim().isEmpty() || targetId == null || targetId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u677f\u4ee3\u7801\u548c\u76ee\u6807ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.querySceneByTemplateAndTarget(templateCode, targetId, dimension);
    }

    @PostMapping(value={"/translateContent"})
    public Object translateContent(@RequestBody Object content) throws Exception {
        if (content == null) {
            throw new DWBusinessException("500", "\u7ffb\u8bd1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.getTranslateContent(content);
    }

    @PostMapping(value={"/createMonitorRule"})
    public Object createMonitorRule(@RequestBody Map<String, Object> params) throws Exception {
        String code = params.getOrDefault("code", "").toString();
        String name = params.getOrDefault("name", "").toString();
        String appCode = params.getOrDefault("appCode", "").toString();
        String appName = params.getOrDefault("appName", "").toString();
        String productName = params.getOrDefault("productName", "").toString();
        if (code == null || code.trim().isEmpty() || name == null || name.trim().isEmpty() || appCode == null || appCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4ee3\u7801\u3001\u540d\u79f0\u548c\u5e94\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.createMonitorRule(code, name, appCode, appName, productName);
    }

    @PostMapping(value={"/pushData"})
    public Object pushData(@RequestBody Map<String, Object> params) throws Exception {
        List appCodes = params.get("appCodes") == null ? null : (List)params.get("appCodes");
        String tenantId = params.getOrDefault("tenantId", "").toString();
        String version = params.getOrDefault("version", "").toString();
        if (appCodes == null || appCodes.isEmpty() || tenantId == null || tenantId.trim().isEmpty() || version == null || version.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5e94\u7528\u4ee3\u7801\u5217\u8868\u3001\u79df\u6237ID\u548c\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.pushData(appCodes, tenantId, version);
    }

    @PostMapping(value={"/removeData"})
    public Object removeData(@RequestBody Map<String, Object> params) {
        String type = params.getOrDefault("type", "").toString();
        String sceneCode = params.getOrDefault("sceneCode", "").toString();
        if (type == null || type.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u7c7b\u578b\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.removeData(type, sceneCode);
    }

    @PostMapping(value={"/queryActionIntentions"})
    public List<ActionIntentions> queryActionIntentions(@RequestBody Map<String, Object> params) {
        List actionIds;
        List list = actionIds = params.get("actionIds") == null ? null : (List)params.get("actionIds");
        if (actionIds == null || actionIds.isEmpty()) {
            throw new DWBusinessException("500", "\u52a8\u4f5cID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryActionIntentions(actionIds);
    }

    @PostMapping(value={"/queryActionRecast"})
    public List<ActionRecast> queryActionRecast(@RequestBody Map<String, Object> params) {
        List actionIds;
        List list = actionIds = params.get("actionIds") == null ? null : (List)params.get("actionIds");
        if (actionIds == null || actionIds.isEmpty()) {
            throw new DWBusinessException("500", "\u52a8\u4f5cID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryActionRecast(actionIds);
    }

    @PostMapping(value={"/queryActionRelation"})
    public Object queryActionRelation(@RequestBody Map<String, Object> params) throws Exception {
        List actionIds;
        List list = actionIds = params.get("actionIds") == null ? null : (List)params.get("actionIds");
        if (actionIds == null || actionIds.isEmpty()) {
            throw new DWBusinessException("500", "\u52a8\u4f5cID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryActionRelation(actionIds);
    }

    @PostMapping(value={"/queryActionReportConfig"})
    public List<Object> queryActionReportConfig(@RequestBody Map<String, Object> params) throws Exception {
        List actionIds;
        List list = actionIds = params.get("actionIds") == null ? null : (List)params.get("actionIds");
        if (actionIds == null || actionIds.isEmpty()) {
            throw new DWBusinessException("500", "\u52a8\u4f5cID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryActionReportConfig(actionIds);
    }

    @PostMapping(value={"/querySceneTemplate"})
    public Object querySceneTemplate(@RequestBody Map<String, Object> params) {
        List templateCodes;
        List list = templateCodes = params.get("actionIds") == null ? null : (List)params.get("actionIds");
        if (templateCodes == null || templateCodes.isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u677f\u4ee3\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.querySceneTemplate(templateCodes);
    }

    @GetMapping(value={"/querySceneTargetInfo"})
    public Object querySceneTargetInfo(@RequestParam String targetCode) {
        if (targetCode == null || targetCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u76ee\u6807\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.querySceneTargetInfo(targetCode);
    }

    @PostMapping(value={"/modelCenterMetaData"})
    public List<GetActionLocaleResponseDTO> modelCenterMetaData(@RequestBody Map<String, Object> params) throws Exception {
        List modelIds;
        List list = modelIds = params.get("modelIds") == null ? null : (List)params.get("modelIds");
        if (modelIds == null || modelIds.isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u578bID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.modelCenterMetaData(modelIds);
    }

    @GetMapping(value={"/createPullingDataMap"})
    public Object createPullingDataMap() throws Exception {
        return this.sceneService.createPullingDataMap();
    }

    @GetMapping(value={"/createPullingDataRelation"})
    public Object createPullingDataRelation() {
        return this.sceneService.createPullingDataRelation();
    }

    @GetMapping(value={"/sceneSchema"})
    public Object sceneSchema(@RequestParam String sceneCode) throws Exception {
        if (sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.sceneSchema(sceneCode);
    }

    @PostMapping(value={"/querySceneIntention"})
    public Object querySceneIntention() throws Exception {
        return this.sceneService.querySceneIntention();
    }

    @PostMapping(value={"/querySceneIntentions"})
    public Object querySceneIntentions() throws Exception {
        return this.sceneService.querySceneIntentions();
    }

    @PostMapping(value={"/querySceneByTenantId"})
    public Object querySceneByTenantId(@RequestBody Map<String, Object> params) {
        String tenantId = params.getOrDefault("tenantId", "").toString();
        if (tenantId == null || tenantId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.querySceneByTenantId(tenantId);
    }

    @PostMapping(value={"/queryApplicationByCode"})
    public Object queryApplicationByCode(@RequestBody Map<String, Object> params) throws Exception {
        String code = params.getOrDefault("sceneCode", "").toString();
        if (code == null || code.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5e94\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryApplicationByCode(code);
    }

    @PostMapping(value={"/queryDataSetsByApp"})
    public Object queryDataSetsByApp(@RequestBody Map<String, Object> params) throws Exception {
        String appCode = params.getOrDefault("appCode", "").toString();
        if (appCode == null || appCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5e94\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sceneService.queryDataSetsByApp(appCode);
    }
}

