/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.model.userScreen.UserScreenConfig;
import com.digiwin.athena.agiledataquery.model.userScreen.UserScreenConfigDTO;
import com.digiwin.athena.agiledataquery.service.IScreenService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/screen"})
public class ScreenController {
    private static final Logger log = LoggerFactory.getLogger(ScreenController.class);
    @Autowired
    private IScreenService screenService;

    @GetMapping(value={"/userPermissionScreen"})
    public Object userPermissionScreen(@RequestParam List<String> type, @RequestParam(required=false) List<String> appCodes, @RequestParam(required=false) String userId) throws DWBusinessException {
        if (StringUtils.isNotEmpty((CharSequence)userId) && CollectionUtils.isNotEmpty(appCodes)) {
            return this.screenService.getUserPermissionScreen(userId, type, appCodes);
        }
        return this.screenService.getUserPermissionScreen(type);
    }

    @PostMapping(value={"/querySceneByApp"})
    public Object querySceneByApp(@RequestBody Map<String, Object> body) throws Exception {
        List appCodes = (List)body.get("appCodes");
        return this.screenService.postQuerySceneByApp(appCodes);
    }

    @PostMapping(value={"/addUserScreen"})
    public Object addUserScreen(@RequestBody Map<String, Object> body) throws Exception {
        UserScreenConfigDTO config = (UserScreenConfigDTO)JSON.parseObject((String)JSON.toJSONString((Object)body.get("config")), UserScreenConfigDTO.class);
        if (config == null) {
            throw new DWBusinessException("500", "\u5927\u5c4f\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.screenService.postAddUserScreen(config);
    }

    @PostMapping(value={"/deleteUserScreen"})
    public Object deleteUserScreen(@RequestBody Map<String, Object> body) throws Exception {
        List codes = (List)body.get("codes");
        if (codes == null || codes.isEmpty()) {
            throw new DWBusinessException("500", "\u5927\u5c4f\u4ee3\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.screenService.postDeleteUserScreen(codes);
    }

    @PostMapping(value={"/queryUserScreen"})
    public UserScreenConfig queryUserScreen(@RequestBody Map<String, Object> body) throws Exception {
        String code = (String)body.get("code");
        if (code == null || code.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5927\u5c4f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.screenService.postQueryUserScreen(code);
    }

    @PostMapping(value={"/queryUserScreenByCode"})
    public Object queryUserScreenByCode(@RequestBody Map<String, Object> body) throws Exception {
        String code = (String)body.get("code");
        if (code == null || code.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5927\u5c4f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.screenService.postQueryUserScreenByCode(code);
    }
}

