/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.model.userScreen.UserScreenConfig;
import com.digiwin.athena.agiledataquery.service.ISectorService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/sector"})
public class SectorController {
    private static final Logger log = LoggerFactory.getLogger(SectorController.class);
    @Autowired
    private ISectorService sectorService;

    @GetMapping(value={"/userSectors"})
    public Object userSectors() throws Exception {
        String userId = AthenaUtils.getUserId();
        return this.sectorService.getUserSectors();
    }

    @PostMapping(value={"/reportSceneByBkCode"})
    public Object reportSceneByBkCode(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = params.get("tenantId").toString();
        UserScreenConfig userScreen = (UserScreenConfig)params.get("userScreen");
        return this.sectorService.getReportSceneByBkCode(tenantId, userScreen);
    }
}

