/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.dao;

import com.digiwin.athena.agiledataquery.domain.activity.Activity;
import com.digiwin.athena.agiledataquery.domain.activity.ActivityBaseInfoVO;
import com.digiwin.athena.agiledataquery.domain.common.BaseEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityDAO {
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplateSystem;

    public List<String> getAllABiReportCodes() {
        Criteria criteria = Criteria.where((String)"category").is((Object)"ABI-STATEMENT");
        List result = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
        return result.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
    }

    public List<Activity> getActivityByCodeAndVersion(String activityCode, String tenantVersion, String tenantId) {
        Criteria criteria = Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)tenantVersion).andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Activity> getCommonBaseData(String tenantId) {
        Criteria criteria = Criteria.where((String)"nameSpace").is((Object)"common").andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<ActivityBaseInfoVO> getApproveActivityListByActivityIds(List<String> activityIdList, String tenantId, String tenantVersion) {
        Criteria criteria = Criteria.where((String)"code").in(activityIdList).and("version").is((Object)tenantVersion).and("category").is((Object)"APPROVAL").andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, false)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), ActivityBaseInfoVO.class, "activityConfigsBasic");
    }

    public List<Activity> getActivitiesByPattern(String tenantId, String pattern, String tenantVersion, List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("version").is((Object)tenantVersion).and("pattern").is((Object)pattern).andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Activity> getReportActivitiesByCode(List<String> reportCodes, String tenantId, String tenantVersion) {
        Criteria criteria = Criteria.where((String)"code").in(reportCodes).and("version").is((Object)tenantVersion).andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public Activity findActivityNoTenantId(String bizCode) {
        Criteria criteria = Criteria.where((String)"code").is((Object)bizCode).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"pattern").nin(new Object[]{"DATA_ENTRY", "STATEMENT"}), Criteria.where((String)"pattern").is(null)})});
        return (Activity)this.mongoTemplateSystem.findOne(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Activity> getActivitiesByPatternCondition(String pattern, String condition, String tenantId, String tenantVersion) {
        Criteria nameCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(condition), Criteria.where((String)"lang.name.zh_TW").regex(condition), Criteria.where((String)"lang.name.en_US").regex(condition), Criteria.where((String)"lang.name.zh_CN").regex(condition)});
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"version").is((Object)tenantVersion), Criteria.where((String)"pattern").is((Object)pattern), nameCriteria, this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Activity> getDataEntryByNameSpace(String nameSpace) {
        Criteria criteria = Criteria.where((String)"nameSpace").is((Object)nameSpace).and("pattern").is((Object)"DATA_ENTRY");
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Map> getAllActivity() {
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"code", "name", "nameSpace"});
        ProjectionOperation projectOperation = Aggregation.project((String[])new String[0]).and("$_id.code").as("code").and("$_id.name").as("name").and("$_id.nameSpace").as("nameSpace");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{groupOperation, projectOperation});
        AggregationResults results = this.mongoTemplateSystem.aggregate(aggregation, "activityConfigsBasic", Map.class);
        return results.getMappedResults();
    }

    public Activity findOneByCode(String code) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code);
        return (Activity)this.mongoTemplateSystem.findOne(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public Criteria getCriteriaByTenantId(String tenantId, boolean inclusionTenant) {
        Criteria criteria = Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null});
        if (inclusionTenant) {
            criteria = new Criteria().orOperator(new Criteria[]{criteria, Criteria.where((String)"inclusionTenant").is((Object)tenantId)});
        }
        return criteria;
    }
}

